/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.caching;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.metadata.Attributes;
import org.springframework.util.CollectionUtils;
import org.springmodules.cache.CacheAttribute;
import org.springmodules.cache.interceptor.MetadataCacheAttributeSource;
import org.springmodules.cache.interceptor.caching.Cached;
import org.springmodules.cache.interceptor.caching.CachingAttributeSource;
import org.springmodules.cache.interceptor.caching.CachingUtils;

public final class MetadataCachingAttributeSource
implements CachingAttributeSource {
    Attributes attributes;
    private final MetadataCacheAttributeSource.MetadataFinder finder = new MetadataCacheAttributeSource.MetadataFinder(){

        public CacheAttribute find(Method m) {
            return this.find(MetadataCachingAttributeSource.this.attributes.getAttributes(m));
        }

        private CacheAttribute find(Collection methodAttributes) {
            if (CollectionUtils.isEmpty((Collection)methodAttributes)) {
                return null;
            }
            Iterator i = methodAttributes.iterator();
            while (i.hasNext()) {
                Object attribute = i.next();
                if (!(attribute instanceof Cached)) continue;
                return (Cached)attribute;
            }
            return null;
        }
    };
    private final MetadataCacheAttributeSource source = new MetadataCacheAttributeSource(this.finder);

    public Cached attribute(Method m, Class t) {
        if (!CachingUtils.isCacheable(m)) {
            return null;
        }
        return (Cached)this.source.attribute(m, t);
    }

    public void setAttributes(Attributes a) {
        this.attributes = a;
    }
}

