/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core;

import java.nio.ByteOrder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ReconnConf;
import org.tio.core.DefaultChannelTraceHandler;
import org.tio.core.DefaultTioUuid;
import org.tio.core.PacketHandlerMode;
import org.tio.core.intf.AioHandler;
import org.tio.core.intf.AioListener;
import org.tio.core.intf.ChannelTraceHandler;
import org.tio.core.intf.GroupListener;
import org.tio.core.intf.TioUuid;
import org.tio.core.maintain.ChannelContextMapWithLock;
import org.tio.core.maintain.ChannelContextSetWithLock;
import org.tio.core.maintain.ClientNodeMap;
import org.tio.core.maintain.Groups;
import org.tio.core.maintain.Ids;
import org.tio.core.maintain.IpBlacklist;
import org.tio.core.maintain.IpStats;
import org.tio.core.maintain.Ips;
import org.tio.core.maintain.Tokens;
import org.tio.core.maintain.Users;
import org.tio.core.ssl.SslConfig;
import org.tio.core.stat.GroupStat;
import org.tio.utils.prop.MapWithLockPropSupport;
import org.tio.utils.thread.pool.DefaultThreadFactory;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

public abstract class GroupContext
extends MapWithLockPropSupport {
    static Logger log = LoggerFactory.getLogger(GroupContext.class);
    private static int CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private static final int MAX_POOL_SIZE = CORE_POOL_SIZE * 4 < 256 ? 256 : CORE_POOL_SIZE * 4;
    public static final int READ_BUFFER_SIZE = Integer.getInteger("tio.default.read.buffer.size", 2048);
    public static final long KEEP_ALIVE_TIME = 90L;
    private static final AtomicInteger ID_ATOMIC = new AtomicInteger();
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean isShortConnection = false;
    private SslConfig sslConfig = null;
    protected long heartbeatTimeout = 120000L;
    private PacketHandlerMode packetHandlerMode = PacketHandlerMode.SINGLE_THREAD;
    protected int readBufferSize = READ_BUFFER_SIZE;
    protected ReconnConf reconnConf;
    private ChannelTraceHandler clientTraceHandler = new DefaultChannelTraceHandler();
    private GroupListener groupListener = null;
    private TioUuid tioUuid = new DefaultTioUuid();
    protected SynThreadPoolExecutor tioExecutor = null;
    protected ThreadPoolExecutor groupExecutor = null;
    public final ClientNodeMap clientNodeMap = new ClientNodeMap();
    public final ChannelContextSetWithLock connections = new ChannelContextSetWithLock();
    public final ChannelContextSetWithLock connecteds = new ChannelContextSetWithLock();
    public final ChannelContextSetWithLock closeds = new ChannelContextSetWithLock();
    public final Groups groups = new Groups();
    public final Users users = new Users();
    public final Tokens tokens = new Tokens();
    public final Ids ids = new Ids();
    public final Ips ips = new Ips();
    public IpStats ipStats = null;
    public IpBlacklist ipBlacklist = null;
    public final ChannelContextMapWithLock waitingResps = new ChannelContextMapWithLock();
    protected String id = ID_ATOMIC.incrementAndGet() + "";
    protected int maxDecodeErrorCountForIp = 10;
    protected String name = "\u672a\u547d\u540dGroupContext";
    private boolean isStopped = false;

    public GroupContext() {
        this(null, null);
    }

    public GroupContext(SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) {
        this.ipBlacklist = new IpBlacklist(this.id, this);
        this.ipStats = new IpStats(this, null, null);
        this.tioExecutor = tioExecutor;
        if (this.tioExecutor == null) {
            LinkedBlockingQueue tioQueue = new LinkedBlockingQueue();
            String tioThreadName = "tio";
            this.tioExecutor = new SynThreadPoolExecutor(CORE_POOL_SIZE, CORE_POOL_SIZE, 90L, tioQueue, (ThreadFactory)DefaultThreadFactory.getInstance((String)tioThreadName, (Integer)5), tioThreadName);
            this.tioExecutor.prestartAllCoreThreads();
        }
        this.groupExecutor = groupExecutor;
        if (this.groupExecutor == null) {
            LinkedBlockingQueue<Runnable> groupQueue = new LinkedBlockingQueue<Runnable>();
            String groupThreadName = "tio-group";
            this.groupExecutor = new ThreadPoolExecutor(MAX_POOL_SIZE, MAX_POOL_SIZE, 90L, TimeUnit.SECONDS, groupQueue, (ThreadFactory)DefaultThreadFactory.getInstance((String)groupThreadName, (Integer)5));
            this.groupExecutor.prestartAllCoreThreads();
        }
    }

    public abstract AioHandler getAioHandler();

    public abstract AioListener getAioListener();

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public ChannelTraceHandler getClientTraceHandler() {
        return this.clientTraceHandler;
    }

    public ThreadPoolExecutor getGroupExecutor() {
        return this.groupExecutor;
    }

    public GroupListener getGroupListener() {
        return this.groupListener;
    }

    public abstract GroupStat getGroupStat();

    public long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PacketHandlerMode getPacketHandlerMode() {
        return this.packetHandlerMode;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public ReconnConf getReconnConf() {
        return this.reconnConf;
    }

    public SynThreadPoolExecutor getTioExecutor() {
        return this.tioExecutor;
    }

    public TioUuid getTioUuid() {
        return this.tioUuid;
    }

    public ChannelContextMapWithLock getWaitingResps() {
        return this.waitingResps;
    }

    public boolean isShortConnection() {
        return this.isShortConnection;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setClientTraceHandler(ChannelTraceHandler clientTraceHandler) {
        this.clientTraceHandler = clientTraceHandler;
    }

    public void setGroupListener(GroupListener groupListener) {
        this.groupListener = groupListener;
    }

    public void setHeartbeatTimeout(long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPacketHandlerMode(PacketHandlerMode packetHandlerMode) {
        this.packetHandlerMode = packetHandlerMode;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setShortConnection(boolean isShortConnection) {
        this.isShortConnection = isShortConnection;
    }

    public void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public void setTioUuid(TioUuid tioUuid) {
        this.tioUuid = tioUuid;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
    }
}

