/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.task;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelAction;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.intf.Packet;
import org.tio.core.maintain.ChannelContextMapWithLock;
import org.tio.core.stat.IpStat;
import org.tio.utils.thread.pool.AbstractQueueRunnable;

public class HandlerRunnable
extends AbstractQueueRunnable<Packet> {
    private static final Logger log = LoggerFactory.getLogger(HandlerRunnable.class);
    private ChannelContext channelContext = null;
    private AtomicLong synFailCount = new AtomicLong();

    public HandlerRunnable(ChannelContext channelContext, Executor executor) {
        super(executor);
        this.channelContext = channelContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handler(Packet packet) {
        block11: {
            GroupContext groupContext = this.channelContext.getGroupContext();
            try {
                Integer synSeq = packet.getSynSeq();
                if (synSeq != null && synSeq > 0) {
                    ChannelContextMapWithLock syns = this.channelContext.getGroupContext().getWaitingResps();
                    Packet initPacket = syns.remove(synSeq);
                    if (initPacket != null) {
                        Packet packet2 = initPacket;
                        synchronized (packet2) {
                            syns.put(synSeq, packet);
                            initPacket.notify();
                            break block11;
                        }
                    }
                    log.error("[{}]\u540c\u6b65\u6d88\u606f\u5931\u8d25, synSeq is {}, \u4f46\u662f\u540c\u6b65\u96c6\u5408\u4e2d\u6ca1\u6709\u5bf9\u5e94key\u503c", (Object)this.synFailCount.incrementAndGet(), (Object)synSeq);
                    break block11;
                }
                this.channelContext.traceClient(ChannelAction.BEFORE_HANDLER, packet, null);
                groupContext.getAioHandler().handler(packet, this.channelContext);
                this.channelContext.traceClient(ChannelAction.AFTER_HANDLER, packet, null);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            finally {
                this.channelContext.getStat().getHandledPackets().incrementAndGet();
                this.channelContext.getStat().getHandledBytes().addAndGet(packet.getByteCount());
                groupContext.getGroupStat().getHandledPacket().incrementAndGet();
                groupContext.getGroupStat().getHandledBytes().addAndGet(packet.getByteCount());
                List<Long> list = groupContext.ipStats.durationList;
                for (Long v : list) {
                    IpStat ipStat = groupContext.ipStats.get(v, this.channelContext.getClientNode().getIp());
                    ipStat.getHandledPackets().incrementAndGet();
                    ipStat.getHandledBytes().addAndGet(packet.getByteCount());
                }
            }
        }
    }

    public void runTask() {
        Packet packet = null;
        while ((packet = (Packet)this.msgQueue.poll()) != null) {
            this.handler(packet);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.channelContext.toString();
    }
}

