/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.activemq;

import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class ArtemisContainer
extends GenericContainer<ArtemisContainer> {
    private static final DockerImageName DEFAULT_IMAGE = DockerImageName.parse((String)"apache/activemq-artemis");
    private static final int WEB_CONSOLE_PORT = 8161;
    private static final int TCP_PORT = 61616;
    private static final int HORNETQ_STOMP_PORT = 5445;
    private static final int AMQP_PORT = 5672;
    private static final int STOMP_PORT = 61613;
    private static final int MQTT_PORT = 1883;
    private static final int WS_PORT = 61614;
    private String username = "artemis";
    private String password = "artemis";

    public ArtemisContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public ArtemisContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE});
        this.withExposedPorts(new Integer[]{8161, 61616, 5445, 5672, 61613, 1883, 61614});
        this.waitingFor(Wait.forLogMessage((String)".*HTTP Server started.*", (int)1).withStartupTimeout(Duration.ofMinutes(1L)));
    }

    protected void configure() {
        this.withEnv("ARTEMIS_USER", this.username);
        this.withEnv("ARTEMIS_PASSWORD", this.password);
    }

    public ArtemisContainer withUser(String username) {
        this.username = username;
        return this;
    }

    public ArtemisContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    public String getBrokerUrl() {
        return String.format("tcp://%s:%s", this.getHost(), this.getMappedPort(61616));
    }

    public String getUser() {
        return (String)this.getEnvMap().get("ARTEMIS_USER");
    }

    public String getPassword() {
        return (String)this.getEnvMap().get("ARTEMIS_PASSWORD");
    }
}

