/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.core;

import org.testcontainers.shaded.freemarker.core.Environment;
import org.testcontainers.shaded.freemarker.core.Expression;
import org.testcontainers.shaded.freemarker.core.ParameterRole;
import org.testcontainers.shaded.freemarker.template.TemplateBooleanModel;
import org.testcontainers.shaded.freemarker.template.TemplateModel;

final class BooleanLiteral
extends Expression {
    private final boolean val;

    public BooleanLiteral(boolean val) {
        this.val = val;
    }

    static TemplateBooleanModel getTemplateModel(boolean b) {
        return b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }

    @Override
    boolean evalToBoolean(Environment env) {
        return this.val;
    }

    @Override
    public String getCanonicalForm() {
        return this.val ? "true" : "false";
    }

    @Override
    String getNodeTypeSymbol() {
        return this.getCanonicalForm();
    }

    @Override
    public String toString() {
        return this.val ? "true" : "false";
    }

    @Override
    TemplateModel _eval(Environment env) {
        return this.val ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
    }

    @Override
    boolean isLiteral() {
        return true;
    }

    @Override
    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new BooleanLiteral(this.val);
    }

    @Override
    int getParameterCount() {
        return 0;
    }

    @Override
    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }
}

