/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.web.webflux;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;
import org.thymeleaf.spring5.web.webflux.ISpringWebFluxWebApplication;
import org.thymeleaf.spring5.web.webflux.ISpringWebFluxWebExchange;
import org.thymeleaf.spring5.web.webflux.SpringWebFluxWebExchange;
import org.thymeleaf.spring5.web.webflux.SpringWebFluxWebRequest;
import org.thymeleaf.util.Validate;

public final class SpringWebFluxWebApplication
implements ISpringWebFluxWebApplication {
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    SpringWebFluxWebApplication(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    public static SpringWebFluxWebApplication buildApplication(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        return new SpringWebFluxWebApplication(reactiveAdapterRegistry);
    }

    public ISpringWebFluxWebExchange buildExchange(ServerWebExchange exchange, Locale locale, MediaType mediaType, Charset charset) {
        Validate.notNull((Object)exchange, (String)"ServerWebExchange cannot be null");
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        Validate.notNull((Object)mediaType, (String)"Media Type cannot be null");
        Validate.notNull((Object)charset, (String)"Charset cannot be null");
        SpringWebFluxWebRequest request = new SpringWebFluxWebRequest(exchange.getRequest());
        return new SpringWebFluxWebExchange(request, this, exchange, locale, mediaType, charset);
    }

    @Override
    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public void setAttributeValue(String name, Object value) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        throw new UnsupportedOperationException("No support for application-level attributes in Spring WebFlux");
    }

    public void removeAttribute(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        throw new UnsupportedOperationException("No support for application-level attributes in Spring WebFlux");
    }

    public boolean resourceExists(String path) {
        Validate.notNull((Object)path, (String)"Path cannot be null");
        throw new UnsupportedOperationException("No support for webapplication-based resource resolution in Spring WebFlux");
    }

    public InputStream getResourceAsStream(String path) {
        Validate.notNull((Object)path, (String)"Path cannot be null");
        throw new UnsupportedOperationException("No support for webapplication-based resource resolution in Spring WebFlux");
    }
}

