/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandler;

public abstract class RequestHandlerBase
implements RequestHandler {
    private final Charset UTF8 = Charset.forName("UTF8");

    protected void writeResponse(RequestEvent event, String body) throws IOException {
        HttpServletResponse response = event.getResponse();
        InputStream templateStream = this.loadResource("template.html");
        BufferedReader templateReader = new BufferedReader(new InputStreamReader(templateStream));
        response.setContentType("text/html");
        ServletOutputStream outputStream = response.getOutputStream();
        String templateLine = null;
        while ((templateLine = templateReader.readLine()) != null) {
            String displayName = "";
            if (event.getContext().getServletContextName() != null) {
                displayName = "<h2>" + event.getContext().getServletContextName() + "</h2>";
            }
            String outputLine = templateLine.replace("%CONTENT%", body).replace("%SERVER_INFO%", event.getContext().getServerInfo()).replace("%DISPLAY_NAME%", displayName);
            outputStream.write(outputLine.getBytes(this.UTF8));
        }
        response.flushBuffer();
    }

    protected String evaluateTemplate(String template, Map<String, String> model) {
        String result = template;
        for (Map.Entry<String, String> e : model.entrySet()) {
            result = result.replace(e.getKey(), e.getValue());
        }
        return result;
    }

    protected String getResourceAsString(String name) throws IOException {
        InputStream stream = this.loadResource(name);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.copy(stream, bos);
        return new String(bos.toByteArray(), this.UTF8);
    }

    protected InputStream loadResource(String name) {
        String templateName = RequestHandler.class.getPackage().getName().replace('.', '/') + "/" + name;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(templateName);
    }

    protected void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }
}

