/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.togglz.console.shade.jmte.AnnotationProcessor;
import org.togglz.console.shade.jmte.DefaultModelAdaptor;
import org.togglz.console.shade.jmte.ErrorHandler;
import org.togglz.console.shade.jmte.ModelAdaptor;
import org.togglz.console.shade.jmte.NamedRenderer;
import org.togglz.console.shade.jmte.ProcessListener;
import org.togglz.console.shade.jmte.Renderer;
import org.togglz.console.shade.jmte.RendererRegistry;
import org.togglz.console.shade.jmte.ScopedMap;
import org.togglz.console.shade.jmte.TemplateContext;
import org.togglz.console.shade.jmte.message.DefaultErrorHandler;
import org.togglz.console.shade.jmte.message.SilentErrorHandler;
import org.togglz.console.shade.jmte.renderer.DefaultCollectionRenderer;
import org.togglz.console.shade.jmte.renderer.DefaultIterableRenderer;
import org.togglz.console.shade.jmte.renderer.DefaultMapRenderer;
import org.togglz.console.shade.jmte.renderer.DefaultObjectRenderer;
import org.togglz.console.shade.jmte.template.DynamicBytecodeCompiler;
import org.togglz.console.shade.jmte.template.InterpretedTemplate;
import org.togglz.console.shade.jmte.template.Template;
import org.togglz.console.shade.jmte.template.TemplateCompiler;
import org.togglz.console.shade.jmte.token.IfToken;
import org.togglz.console.shade.jmte.token.Token;
import org.togglz.console.shade.jmte.util.Util;

public final class Engine
implements RendererRegistry {
    public static final String VERSION = "@version@";
    private String exprStartToken = "${";
    private String exprEndToken = "}";
    private double expansionSizeFactor = 2.0;
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private boolean useCompilation = false;
    private boolean enabledInterpretedTemplateCache = true;
    private ModelAdaptor modelAdaptor = new DefaultModelAdaptor();
    private TemplateCompiler compiler = new DynamicBytecodeCompiler();
    private final Map<String, Template> compiledTemplates = new HashMap<String, Template>();
    private final Map<String, Template> interpretedTemplates = new HashMap<String, Template>();
    private final Map<Class<?>, Renderer<?>> renderers = new HashMap();
    private final Map<Class<?>, Renderer<?>> resolvedRendererCache = new HashMap();
    private final Map<String, AnnotationProcessor<?>> annotationProcessors = new HashMap();
    private final Map<String, NamedRenderer> namedRenderers = new HashMap<String, NamedRenderer>();
    private final Map<Class<?>, Set<NamedRenderer>> namedRenderersForClass = new HashMap();

    public static Engine createCachingEngine() {
        Engine engine = new Engine();
        engine.setEnabledInterpretedTemplateCache(true);
        return engine;
    }

    public static Engine createNonCachingEngine() {
        Engine engine = new Engine();
        engine.setEnabledInterpretedTemplateCache(false);
        return engine;
    }

    public static Engine createCompilingEngine() {
        Engine engine = new Engine();
        engine.setUseCompilation(true);
        return engine;
    }

    public static Engine createDefaultEngine() {
        Engine engine = new Engine();
        return engine;
    }

    public Engine() {
        this.init();
    }

    private void init() {
        this.registerRenderer(Object.class, new DefaultObjectRenderer());
        this.registerRenderer(Map.class, new DefaultMapRenderer());
        this.registerRenderer(Collection.class, new DefaultCollectionRenderer());
        this.registerRenderer(Iterable.class, new DefaultIterableRenderer());
    }

    public boolean variablesAvailable(Map<String, Object> model, String ... vars) {
        TemplateContext context = new TemplateContext(null, null, null, new ScopedMap(model), this.modelAdaptor, this, new SilentErrorHandler(), null);
        for (String var : vars) {
            IfToken token = new IfToken(var, false);
            if (((Boolean)token.evaluate(context)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized String transform(String template, Locale locale, String sourceName, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, locale, sourceName, model, this.getModelAdaptor(), processListener);
    }

    public synchronized String transform(String template, String sourceName, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, sourceName, model, this.getModelAdaptor(), processListener);
    }

    public synchronized String transform(String template, Locale locale, String sourceName, Map<String, Object> model) {
        return this.transformInternal(template, locale, sourceName, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, String sourceName, Map<String, Object> model) {
        return this.transformInternal(template, sourceName, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, Locale locale, Map<String, Object> model) {
        return this.transformInternal(template, locale, null, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, Map<String, Object> model) {
        return this.transformInternal(template, null, model, this.getModelAdaptor(), null);
    }

    public synchronized String transform(String template, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, null, model, this.getModelAdaptor(), processListener);
    }

    public synchronized String transform(String template, Locale locale, Map<String, Object> model, ProcessListener processListener) {
        return this.transformInternal(template, locale, null, model, this.getModelAdaptor(), processListener);
    }

    String transformInternal(String template, String sourceName, Map<String, Object> model, ModelAdaptor modelAdaptor, ProcessListener processListener) {
        Locale locale = Locale.getDefault();
        return this.transformInternal(template, locale, sourceName, model, modelAdaptor, processListener);
    }

    String transformInternal(String template, Locale locale, String sourceName, Map<String, Object> model, ModelAdaptor modelAdaptor, ProcessListener processListener) {
        Template templateImpl = this.getTemplate(template, sourceName);
        String output = templateImpl.transform(model, locale, modelAdaptor, processListener);
        return output;
    }

    public synchronized String format(String pattern, final Object ... args) {
        Map<String, Object> model = Collections.emptyMap();
        ModelAdaptor modelAdaptor = new ModelAdaptor(){

            @Override
            public Object getValue(TemplateContext context, Token token, List<String> segments, String expression) {
                int index = Integer.parseInt(expression) - 1;
                return args[index];
            }
        };
        String output = this.transformInternal(pattern, null, model, modelAdaptor, null);
        return output;
    }

    public synchronized Set<String> getUsedVariables(String template) {
        Template templateImpl = this.getTemplate(template, null);
        return templateImpl.getUsedVariables();
    }

    @Override
    public synchronized Engine registerNamedRenderer(NamedRenderer renderer) {
        this.namedRenderers.put(renderer.getName(), renderer);
        Set<Class<?>> supportedClasses = Util.asSet(renderer.getSupportedClasses());
        Iterator<Class<?>> i$ = supportedClasses.iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            for (Class<?> classInHierarchy = clazz = i$.next(); classInHierarchy != null; classInHierarchy = classInHierarchy.getSuperclass()) {
                this.addSupportedRenderer(classInHierarchy, renderer);
            }
        }
        return this;
    }

    @Override
    public synchronized Engine deregisterNamedRenderer(NamedRenderer renderer) {
        this.namedRenderers.remove(renderer.getName());
        Set<Class<?>> supportedClasses = Util.asSet(renderer.getSupportedClasses());
        Iterator<Class<?>> i$ = supportedClasses.iterator();
        while (i$.hasNext()) {
            Class<?> clazz;
            for (Class<?> classInHierarchy = clazz = i$.next(); classInHierarchy != null; classInHierarchy = classInHierarchy.getSuperclass()) {
                Set<NamedRenderer> renderers = this.namedRenderersForClass.get(classInHierarchy);
                renderers.remove(renderer);
            }
        }
        return this;
    }

    private void addSupportedRenderer(Class<?> clazz, NamedRenderer renderer) {
        Collection<NamedRenderer> compatibleRenderers = this.getCompatibleRenderers(clazz);
        compatibleRenderers.add(renderer);
    }

    @Override
    public synchronized Collection<NamedRenderer> getCompatibleRenderers(Class<?> inputType) {
        Set<NamedRenderer> renderers = this.namedRenderersForClass.get(inputType);
        if (renderers == null) {
            renderers = new HashSet<NamedRenderer>();
            this.namedRenderersForClass.put(inputType, renderers);
        }
        return renderers;
    }

    @Override
    public synchronized Collection<NamedRenderer> getAllNamedRenderers() {
        Collection<NamedRenderer> values = this.namedRenderers.values();
        return values;
    }

    @Override
    public NamedRenderer resolveNamedRenderer(String rendererName) {
        return this.namedRenderers.get(rendererName);
    }

    public synchronized Engine registerAnnotationProcessor(AnnotationProcessor<?> annotationProcessor) {
        this.annotationProcessors.put(annotationProcessor.getType(), annotationProcessor);
        return this;
    }

    public synchronized Engine deregisterAnnotationProcessor(AnnotationProcessor<?> annotationProcessor) {
        this.annotationProcessors.remove(annotationProcessor.getType());
        return this;
    }

    AnnotationProcessor<?> resolveAnnotationProcessor(String type) {
        return this.annotationProcessors.get(type);
    }

    @Override
    public synchronized <C> Engine registerRenderer(Class<C> clazz, Renderer<C> renderer) {
        this.renderers.put(clazz, renderer);
        this.resolvedRendererCache.clear();
        return this;
    }

    @Override
    public synchronized Engine deregisterRenderer(Class<?> clazz) {
        this.renderers.remove(clazz);
        this.resolvedRendererCache.clear();
        return this;
    }

    @Override
    public <C> Renderer<C> resolveRendererForClass(Class<C> clazz) {
        Class<C> superclass;
        Renderer<Object> resolvedRenderer = this.resolvedRendererCache.get(clazz);
        if (resolvedRenderer != null) {
            return resolvedRenderer;
        }
        resolvedRenderer = this.renderers.get(clazz);
        if (resolvedRenderer == null) {
            Class<?> interfaze;
            Class<?>[] interfaces;
            Class<?>[] arr$ = interfaces = clazz.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (resolvedRenderer = this.resolveRendererForClass(interfaze = arr$[i$])) == null; ++i$) {
            }
        }
        if (resolvedRenderer == null && (superclass = clazz.getSuperclass()) != null) {
            resolvedRenderer = this.resolveRendererForClass(superclass);
        }
        if (resolvedRenderer != null) {
            this.resolvedRendererCache.put(clazz, resolvedRenderer);
        }
        return resolvedRenderer;
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public synchronized ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public synchronized String getExprStartToken() {
        return this.exprStartToken;
    }

    public synchronized String getExprEndToken() {
        return this.exprEndToken;
    }

    public synchronized void setExprStartToken(String exprStartToken) {
        this.exprStartToken = exprStartToken;
    }

    public synchronized void setExprEndToken(String exprEndToken) {
        this.exprEndToken = exprEndToken;
    }

    public synchronized void setExpansionSizeFactor(double expansionSizeFactor) {
        this.expansionSizeFactor = expansionSizeFactor;
    }

    public synchronized double getExpansionSizeFactor() {
        return this.expansionSizeFactor;
    }

    public synchronized boolean isUseCompilation() {
        return this.useCompilation;
    }

    public synchronized void setUseCompilation(boolean useCompilation) {
        this.useCompilation = useCompilation;
    }

    public synchronized void setModelAdaptor(ModelAdaptor modelAdaptor) {
        this.modelAdaptor = modelAdaptor;
    }

    public synchronized ModelAdaptor getModelAdaptor() {
        return this.modelAdaptor;
    }

    public synchronized boolean isEnabledInterpretedTemplateCache() {
        return this.enabledInterpretedTemplateCache;
    }

    public synchronized void setEnabledInterpretedTemplateCache(boolean enabledInterpretedTemplateCache) {
        this.enabledInterpretedTemplateCache = enabledInterpretedTemplateCache;
    }

    public Template getTemplate(String template) {
        return this.getTemplate(template, null);
    }

    public Template getTemplate(String template, String sourceName) {
        Template templateImpl;
        if (this.useCompilation) {
            Template templateImpl2 = this.compiledTemplates.get(template);
            if (templateImpl2 == null) {
                templateImpl2 = this.compiler.compile(template, sourceName, this);
                this.compiledTemplates.put(template, templateImpl2);
            }
            return templateImpl2;
        }
        if (this.enabledInterpretedTemplateCache) {
            templateImpl = this.interpretedTemplates.get(template);
            if (templateImpl == null) {
                templateImpl = new InterpretedTemplate(template, sourceName, this);
                this.interpretedTemplates.put(template, templateImpl);
            }
        } else {
            templateImpl = new InterpretedTemplate(template, sourceName, this);
        }
        return templateImpl;
    }

    public void setCompiler(TemplateCompiler compiler) {
        this.compiler = compiler;
    }

    public TemplateCompiler getCompiler() {
        return this.compiler;
    }
}

