/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.handlers.edit;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandlerBase;
import org.togglz.console.model.FeatureModel;
import org.togglz.console.shade.jmte.Engine;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.util.Lists;

public class EditPageHandler
extends RequestHandlerBase {
    @Override
    public boolean handles(String path) {
        return path.equals("/edit");
    }

    @Override
    public void process(RequestEvent event) throws IOException {
        FeatureState state;
        FeatureManager featureManager = event.getFeatureManager();
        HttpServletRequest request = event.getRequest();
        HttpServletResponse response = event.getResponse();
        Feature feature = null;
        String featureAsString = request.getParameter("f");
        for (Feature f : featureManager.getFeatures()) {
            if (!f.name().equals(featureAsString)) continue;
            feature = f;
        }
        if (feature == null) {
            response.sendError(403);
            return;
        }
        FeatureMetaData metadata = featureManager.getMetaData(feature);
        List impls = Lists.asList(ServiceLoader.load(ActivationStrategy.class).iterator());
        FeatureModel featureModel = new FeatureModel(feature, metadata, impls);
        if ("GET".equals(request.getMethod())) {
            state = featureManager.getFeatureState(feature);
            featureModel.populateFromFeatureState(state);
            this.renderEditPage(event, featureModel);
        }
        if ("POST".equals(request.getMethod())) {
            featureModel.restoreFromRequest(request);
            if (featureModel.isValid()) {
                state = featureModel.toFeatureState();
                featureManager.setFeatureState(state);
                response.sendRedirect("index");
            } else {
                this.renderEditPage(event, featureModel);
            }
        }
    }

    private void renderEditPage(RequestEvent event, FeatureModel featureModel) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("model", featureModel);
        String template = this.getResourceAsString("edit.html");
        String content = new Engine().transform(template, model);
        this.writeResponse(event, content);
    }
}

