/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.handlers.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.togglz.console.handlers.index.IndexPageTab;
import org.togglz.console.model.FeatureModel;
import org.togglz.core.Feature;
import org.togglz.core.group.FeatureGroup;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;

public class IndexPageTabView {
    private final List<ActivationStrategy> strategies;
    private final IndexPageTab allTab;
    private final Map<String, IndexPageTab> tabMap = new HashMap<String, IndexPageTab>();
    private final List<IndexPageTab> tabs = new ArrayList<IndexPageTab>();
    private int nextIndex = 0;

    public IndexPageTabView(List<ActivationStrategy> strategies) {
        this.strategies = strategies;
        this.allTab = IndexPageTab.allTab(this.nextIndex++);
        this.tabs.add(this.allTab);
    }

    public void add(Feature feature, FeatureMetaData metadata, FeatureState featureState) {
        FeatureModel row = new FeatureModel(feature, metadata, this.strategies);
        row.populateFromFeatureState(featureState);
        this.allTab.add(row);
        for (FeatureGroup group : metadata.getGroups()) {
            String label = group.getLabel();
            IndexPageTab tab = this.tabMap.get(label);
            if (tab == null) {
                tab = IndexPageTab.groupTab(this.nextIndex++, label);
                this.tabMap.put(label, tab);
                this.tabs.add(tab);
            }
            tab.add(row);
        }
        Collections.sort(this.tabs);
    }

    public List<IndexPageTab> getTabs() {
        return this.tabs;
    }
}

