/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.togglz.console.model.ParameterModel;
import org.togglz.console.model.StrategyModel;
import org.togglz.core.Feature;
import org.togglz.core.activation.Parameter;
import org.togglz.core.metadata.FeatureMetaData;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.util.Strings;
import org.togglz.core.util.Validate;

public class FeatureModel {
    private final Feature feature;
    private final FeatureMetaData metadata;
    private final List<StrategyModel> strategies = new ArrayList<StrategyModel>();
    private boolean enabled;
    private StrategyModel strategy;

    public FeatureModel(Feature feature, FeatureMetaData metadata, List<ActivationStrategy> impls) {
        this.feature = feature;
        this.metadata = metadata;
        ArrayList<ActivationStrategy> sortedImpls = new ArrayList<ActivationStrategy>(impls);
        Collections.sort(sortedImpls, new Comparator<ActivationStrategy>(){

            @Override
            public int compare(ActivationStrategy o1, ActivationStrategy o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int paramIndex = 1;
        int strategyIndex = 1;
        for (ActivationStrategy impl : sortedImpls) {
            StrategyModel strategy = new StrategyModel(strategyIndex++, impl, this);
            this.strategies.add(strategy);
            for (Parameter param : impl.getParameters()) {
                strategy.add(new ParameterModel(paramIndex++, param, strategy));
            }
        }
    }

    public void populateFromFeatureState(FeatureState featureState) {
        String strategyId = Strings.trimToNull((String)featureState.getStrategyId());
        this.strategy = this.getStrategyById(strategyId);
        this.enabled = featureState.isEnabled();
        for (ParameterModel param : this.getParameters()) {
            param.readValueFrom(featureState);
        }
    }

    public void restoreFromRequest(HttpServletRequest request) {
        String enabledParam = request.getParameter("enabled");
        this.enabled = enabledParam != null && enabledParam.trim().length() > 0;
        String strategyId = request.getParameter("strategy");
        this.strategy = this.getStrategyById(strategyId);
        for (ParameterModel param : this.getParameters()) {
            param.readValueFrom(request);
        }
    }

    public List<String> getValidationErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.strategy != null) {
            for (ParameterModel param : this.strategy.getParameters()) {
                String msg;
                if (param.isValid() || (msg = param.getValidationError()) == null) continue;
                errors.add(msg);
            }
        }
        return errors;
    }

    private StrategyModel getStrategyById(String id) {
        for (StrategyModel strategy : this.strategies) {
            if (!strategy.getId().equals(id)) continue;
            return strategy;
        }
        return null;
    }

    public List<ParameterModel> getParameters() {
        ArrayList<ParameterModel> params = new ArrayList<ParameterModel>();
        for (StrategyModel strategy : this.strategies) {
            params.addAll(strategy.getParameters());
        }
        return params;
    }

    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    public FeatureState toFeatureState() {
        Validate.isTrue((boolean)this.getValidationErrors().isEmpty(), (String)"Calling toFeatureState() is only allowed for a valid model");
        FeatureState state = new FeatureState(this.feature, this.enabled);
        if (this.strategy != null) {
            state.setStrategyId(this.strategy.getId());
            for (ParameterModel param : this.strategy.getParameters()) {
                state.setParameter(param.getId(), Strings.trimToNull((String)param.getValue()));
            }
        }
        return state;
    }

    public List<StrategyModel> getStrategies() {
        return this.strategies;
    }

    public String getLabel() {
        return this.metadata.getLabel();
    }

    public String getName() {
        return this.feature.name();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public StrategyModel getStrategy() {
        return this.strategy;
    }
}

