/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.togglz.console.RequestEvent;
import org.togglz.console.RequestHandler;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.LazyResolvingFeatureManager;
import org.togglz.core.user.FeatureUser;

public class TogglzConsoleServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected final List<RequestHandler> handlers = new ArrayList<RequestHandler>();
    protected ServletContext servletContext;
    protected FeatureManager featureManager;
    protected boolean secured = true;

    public void init(ServletConfig config) {
        this.featureManager = new LazyResolvingFeatureManager();
        this.servletContext = config.getServletContext();
        String secured = this.servletContext.getInitParameter("org.togglz.console.SECURED");
        if (secured != null) {
            this.secured = TogglzConsoleServlet.toBool(secured);
        }
        for (RequestHandler requestHandler : ServiceLoader.load(RequestHandler.class)) {
            this.handlers.add(requestHandler);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestEvent consoleRequest = new RequestEvent(this.featureManager, this.servletContext, request, response);
        String path = consoleRequest.getPath();
        RequestHandler handler = this.getHandlerFor(path);
        if (handler != null) {
            if (!this.secured || !handler.adminOnly() || this.isFeatureAdmin(request)) {
                handler.process(consoleRequest);
            } else {
                response.sendError(403, "You are not allowed to access the Togglz Console");
            }
            return;
        }
        response.sendError(404);
    }

    protected boolean isFeatureAdmin(HttpServletRequest request) {
        FeatureUser user = this.featureManager.getCurrentFeatureUser();
        return user != null && user.isFeatureAdmin();
    }

    private RequestHandler getHandlerFor(String path) {
        for (RequestHandler page : this.handlers) {
            if (!page.handles(path)) continue;
            return page;
        }
        return null;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }

    private static boolean toBool(String value) {
        if (value != null && "true".equalsIgnoreCase(value.trim())) {
            return true;
        }
        if (value != null && "false".equalsIgnoreCase(value.trim())) {
            return false;
        }
        throw new IllegalArgumentException("Not a valid boolean value: " + value);
    }
}

