/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.extended;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.togglz.console.shade.jmte.NamedRenderer;
import org.togglz.console.shade.jmte.RenderFormatInfo;
import org.togglz.console.shade.jmte.util.Util;

public class ChainedNamedRenderer
implements NamedRenderer {
    private final Map<String, NamedRenderer> namedRenderers = new HashMap<String, NamedRenderer>();

    public ChainedNamedRenderer(Collection<NamedRenderer> namedRenderers) {
        namedRenderers.forEach(namedRenderer -> this.namedRenderers.put(namedRenderer.getName(), (NamedRenderer)namedRenderer));
    }

    @Override
    public String render(Object o, String format, Locale locale, Map<String, Object> model) {
        Object result = o;
        List<String> subRenderers = Util.RAW_OUTPUT_MINI_PARSER.split(format, ';', Integer.MAX_VALUE);
        for (String subRenderer : subRenderers) {
            NamedRenderer namedRenderer;
            List<String> strings = Util.MINI_PARSER.greedyScan(subRenderer, "(", ")");
            String rendererName = this.getSafe(strings, 0);
            String rendererParams = this.getSafe(strings, 1);
            if (rendererName == null || rendererName.isEmpty() || (namedRenderer = this.namedRenderers.get(rendererName)) == null) continue;
            result = namedRenderer.render(result, rendererParams, locale, model);
        }
        return String.valueOf(result);
    }

    private String getSafe(List<String> list, int index) {
        if (index < list.size()) {
            return list.get(index);
        }
        return "";
    }

    @Override
    public String getName() {
        return "chain";
    }

    @Override
    public RenderFormatInfo getFormatInfo() {
        return null;
    }

    @Override
    public Class<?>[] getSupportedClasses() {
        return new Class[0];
    }
}

