/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.mavengem;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.torquebox.mojo.mavengem.MavenGemURLConnection;
import org.torquebox.mojo.mavengem.RubygemsFactory;

public class Handler
extends URLStreamHandler {
    public static String KEY = "java.protocol.handler.pkgs";
    public static String PKG = "org.torquebox.mojo";
    public static String PING_URL = "mavengem:https://rubygems.org/maven/releases/ping";
    private static RubygemsFactory factory;
    private String uri;

    public static synchronized boolean isMavenGemProtocolRegistered() {
        return System.getProperties().contains(KEY);
    }

    public static synchronized boolean registerMavenGemProtocol() throws MalformedURLException {
        return Handler.registerMavenGemProtocol(RubygemsFactory.defaultFactory());
    }

    public static synchronized boolean registerMavenGemProtocol(RubygemsFactory rubygemsFactory) {
        if (Handler.ping()) {
            return false;
        }
        factory = rubygemsFactory;
        if (System.getProperties().contains(KEY)) {
            String current = System.getProperty(KEY);
            if (!current.contains(PKG)) {
                System.setProperty(KEY, current + "|" + PKG);
            }
        } else {
            System.setProperty(KEY, PKG);
        }
        return Handler.ping();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean ping() {
        try {
            URL url = new URL(PING_URL);
            try (InputStream in = url.openStream();){
                byte[] data = new byte[in.available()];
                in.read(data, 0, data.length);
                boolean bl = "pong".equals(new String(data));
                return bl;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int end) {
        this.uri = spec.substring(start, end);
        super.parseURL(u, spec, start, end);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return MavenGemURLConnection.create(factory, this.uri);
    }
}

