/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.web.context.request.RequestContextListener;
import org.vaadin.spring.annotation.VaadinUIScope;
import org.vaadin.spring.context.VaadinApplicationContext;
import org.vaadin.spring.http.HttpResponseFactory;
import org.vaadin.spring.http.HttpResponseFilter;
import org.vaadin.spring.http.HttpService;
import org.vaadin.spring.http.VaadinHttpService;
import org.vaadin.spring.internal.VaadinSessionScope;
import org.vaadin.spring.navigator.SpringViewProvider;
import org.vaadin.spring.navigator.internal.DefaultViewCache;
import org.vaadin.spring.navigator.internal.VaadinViewScope;
import org.vaadin.spring.navigator.internal.ViewCache;

@Configuration
public class VaadinConfiguration
implements ApplicationContextAware,
BeanDefinitionRegistryPostProcessor {
    private ApplicationContext applicationContext;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    @Bean
    static VaadinSessionScope vaadinSessionScope() {
        return new VaadinSessionScope();
    }

    @Bean
    static org.vaadin.spring.internal.VaadinUIScope vaadinUIScope() {
        return new org.vaadin.spring.internal.VaadinUIScope();
    }

    @Bean
    static VaadinViewScope vaadinViewScope() {
        return new VaadinViewScope();
    }

    @Bean
    SpringViewProvider viewProvider() {
        return new SpringViewProvider(this.applicationContext, this.beanDefinitionRegistry);
    }

    @Bean
    @VaadinUIScope
    ViewCache viewCache() {
        return new DefaultViewCache();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    VaadinApplicationContext vaadinApplicationContext() {
        return new VaadinApplicationContext();
    }

    @Bean
    RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    HttpResponseFilter httpResponseFilter() {
        return new HttpResponseFilter();
    }

    @Bean
    HttpResponseFactory httpResponseFactory() {
        return new HttpResponseFactory();
    }

    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
    HttpService httpService() {
        return new VaadinHttpService();
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.beanDefinitionRegistry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

