/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.internal;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;

public class BeanStore
implements Serializable {
    private static final long serialVersionUID = 7625347916717427098L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanStore.class);
    private final Map<String, Object> objectMap = new ConcurrentHashMap<String, Object>();
    private final Map<String, Runnable> destructionCallbacks = new ConcurrentHashMap<String, Runnable>();
    private final String name;
    private final DestructionCallback destructionCallback;
    private boolean destroyed = false;

    public BeanStore(String name, DestructionCallback destructionCallback) {
        this.name = name;
        this.destructionCallback = destructionCallback;
    }

    public BeanStore(String name) {
        this(name, null);
    }

    public Object get(String s, ObjectFactory<?> objectFactory) {
        LOGGER.trace("Getting bean with name [{}] from [{}]", (Object)s, (Object)this);
        Object bean = this.objectMap.get(s);
        if (bean == null) {
            bean = this.create(s, objectFactory);
            LOGGER.trace("Added bean [{}] with name [{}] to [{}]", new Object[]{bean, s, this});
            this.objectMap.put(s, bean);
        }
        return bean;
    }

    protected Object create(String s, ObjectFactory<?> objectFactory) {
        Object bean = objectFactory.getObject();
        if (!(bean instanceof Serializable)) {
            LOGGER.warn("Storing non-serializable bean [{}] with name [{}] in [{}]", new Object[]{bean, s, this});
        }
        return bean;
    }

    public Object remove(String s) {
        this.destructionCallbacks.remove(s);
        return this.objectMap.remove(s);
    }

    public void registerDestructionCallback(String s, Runnable runnable) {
        LOGGER.trace("Registering destruction callback for bean with name [{}] in [{}]", (Object)s, (Object)this);
        this.destructionCallbacks.put(s, runnable);
    }

    public void destroy() {
        if (this.destroyed) {
            LOGGER.trace("[{}] has already been destroyed, ignoring", (Object)this);
            return;
        }
        try {
            LOGGER.debug("Destroying [{}]", (Object)this);
            for (Runnable destructionCallback : this.destructionCallbacks.values()) {
                destructionCallback.run();
            }
            this.destructionCallbacks.clear();
            this.objectMap.clear();
            if (this.destructionCallback != null) {
                this.destructionCallback.beanStoreDestroyed(this);
            }
        }
        finally {
            this.destroyed = true;
        }
    }

    public String toString() {
        return String.format("%s[id=%x, name=%s]", this.getClass().getSimpleName(), System.identityHashCode(this), this.name);
    }

    public static interface DestructionCallback
    extends Serializable {
        public void beanStoreDestroyed(BeanStore var1);
    }
}

