/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.navigator;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.ui.UI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.vaadin.spring.navigator.ViewProviderAccessDelegate;
import org.vaadin.spring.navigator.annotation.VaadinView;
import org.vaadin.spring.navigator.internal.VaadinViewScope;
import org.vaadin.spring.navigator.internal.ViewCache;

public class SpringViewProvider
implements ViewProvider {
    private static final long serialVersionUID = 6906237177564157222L;
    private final Map<String, Set<String>> viewNameToBeanNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private final ApplicationContext applicationContext;
    private final BeanDefinitionRegistry beanDefinitionRegistry;
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringViewProvider.class);
    private Class<? extends View> accessDeniedViewClass;

    @Autowired
    public SpringViewProvider(ApplicationContext applicationContext, BeanDefinitionRegistry beanDefinitionRegistry) {
        this.applicationContext = applicationContext;
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    public Class<? extends View> getAccessDeniedViewClass() {
        return this.accessDeniedViewClass;
    }

    public void setAccessDeniedViewClass(Class<? extends View> accessDeniedViewClass) {
        this.accessDeniedViewClass = accessDeniedViewClass;
    }

    @PostConstruct
    void init() {
        String[] viewBeanNames;
        LOGGER.info("Looking up VaadinViews");
        int count = 0;
        for (String beanName : viewBeanNames = this.applicationContext.getBeanNamesForAnnotation(VaadinView.class)) {
            Class type = this.applicationContext.getType(beanName);
            if (!View.class.isAssignableFrom(type)) continue;
            VaadinView annotation = (VaadinView)this.applicationContext.findAnnotationOnBean(beanName, VaadinView.class);
            String viewName = annotation.name();
            LOGGER.debug("Found VaadinView bean [{}] with view name [{}]", (Object)beanName, (Object)viewName);
            if (this.applicationContext.isSingleton(beanName)) {
                throw new IllegalStateException("VaadinView bean [" + beanName + "] must not be a singleton");
            }
            Set<String> beanNames = this.viewNameToBeanNamesMap.get(viewName);
            if (beanNames == null) {
                beanNames = new ConcurrentSkipListSet<String>();
                this.viewNameToBeanNamesMap.put(viewName, beanNames);
            }
            beanNames.add(beanName);
            ++count;
        }
        if (count == 0) {
            LOGGER.warn("No VaadinViews found");
        } else if (count == 1) {
            LOGGER.info("1 VaadinView found");
        } else {
            LOGGER.info("{} VaadinViews found", (Object)count);
        }
    }

    public String getViewName(String viewAndParameters) {
        LOGGER.trace("Extracting view name from [{}]", (Object)viewAndParameters);
        String viewName = null;
        if (this.isViewNameValidForCurrentUI(viewAndParameters)) {
            viewName = viewAndParameters;
        } else {
            int lastSlash = -1;
            String viewPart = viewAndParameters;
            while ((lastSlash = viewPart.lastIndexOf(47)) > -1) {
                viewPart = viewPart.substring(0, lastSlash);
                LOGGER.trace("Checking if [{}] is a valid view", (Object)viewPart);
                if (!this.isViewNameValidForCurrentUI(viewPart)) continue;
                viewName = viewPart;
                break;
            }
        }
        if (viewName == null) {
            LOGGER.trace("Found no view name in [{}]", (Object)viewAndParameters);
        } else {
            LOGGER.trace("[{}] is a valid view", (Object)viewName);
        }
        return viewName;
    }

    private boolean isViewNameValidForCurrentUI(String viewName) {
        Set<String> beanNames = this.viewNameToBeanNamesMap.get(viewName);
        if (beanNames != null) {
            for (String beanName : beanNames) {
                if (!this.isViewBeanNameValidForCurrentUI(beanName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isViewBeanNameValidForCurrentUI(String beanName) {
        try {
            Class type = this.applicationContext.getType(beanName);
            Assert.isAssignable(View.class, (Class)type, (String)"bean did not implement View interface");
            UI currentUI = UI.getCurrent();
            VaadinView annotation = (VaadinView)this.applicationContext.findAnnotationOnBean(beanName, VaadinView.class);
            Assert.notNull((Object)annotation, (String)"class did not have a VaadinView annotation");
            if (annotation.ui().length == 0) {
                LOGGER.trace("View class [{}] with view name [{}] is available for all UI subclasses", (Object)type.getCanonicalName(), (Object)annotation.name());
                return true;
            }
            for (Class<? extends UI> validUI : annotation.ui()) {
                if (validUI != currentUI.getClass()) continue;
                LOGGER.trace("View class [%s] with view name [{}] is available for UI subclass [{}]", new Object[]{type.getCanonicalName(), annotation.name(), validUI.getCanonicalName()});
                return true;
            }
            return false;
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    public View getView(String viewName) {
        Set<String> beanNames = this.viewNameToBeanNamesMap.get(viewName);
        if (beanNames != null) {
            for (String beanName : beanNames) {
                if (!this.isViewBeanNameValidForCurrentUI(beanName)) continue;
                return this.getViewFromApplicationContext(viewName, beanName);
            }
        }
        LOGGER.warn("Found no view with name [{}]", (Object)viewName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View getViewFromApplicationContext(String viewName, String beanName) {
        View view = null;
        if (this.isAccessGrantedToBeanName(beanName)) {
            BeanDefinition beanDefinition = this.beanDefinitionRegistry.getBeanDefinition(beanName);
            if (beanDefinition.getScope().equals("vaadin-view")) {
                LOGGER.trace("View [{}] is view scoped, activating scope", (Object)viewName);
                ViewCache viewCache = VaadinViewScope.getViewCacheRetrievalStrategy().getViewCache((BeanFactory)this.applicationContext);
                viewCache.creatingView(viewName);
                try {
                    view = this.getViewFromApplicationContextAndCheckAccess(beanName);
                }
                finally {
                    viewCache.viewCreated(viewName, view);
                }
            } else {
                view = this.getViewFromApplicationContextAndCheckAccess(beanName);
            }
        }
        if (view != null) {
            return view;
        }
        return this.getAccessDeniedView();
    }

    private View getViewFromApplicationContextAndCheckAccess(String beanName) {
        View view = (View)this.applicationContext.getBean(beanName);
        if (this.isAccessGrantedToViewInstance(beanName, view)) {
            return view;
        }
        return null;
    }

    private View getAccessDeniedView() {
        if (this.accessDeniedViewClass != null) {
            return (View)this.applicationContext.getBean(this.accessDeniedViewClass);
        }
        return null;
    }

    private boolean isAccessGrantedToBeanName(String beanName) {
        UI currentUI = UI.getCurrent();
        Map accessDelegates = this.applicationContext.getBeansOfType(ViewProviderAccessDelegate.class);
        for (ViewProviderAccessDelegate accessDelegate : accessDelegates.values()) {
            if (accessDelegate.isAccessGranted(beanName, currentUI)) continue;
            LOGGER.debug("Access delegate [{}] denied access to view with bean name [{}]", (Object)accessDelegate, (Object)beanName);
            return false;
        }
        return true;
    }

    private boolean isAccessGrantedToViewInstance(String beanName, View view) {
        UI currentUI = UI.getCurrent();
        Map accessDelegates = this.applicationContext.getBeansOfType(ViewProviderAccessDelegate.class);
        for (ViewProviderAccessDelegate accessDelegate : accessDelegates.values()) {
            if (accessDelegate.isAccessGranted(beanName, currentUI, view)) continue;
            LOGGER.debug("Access delegate [{}] denied access to view [{}]", (Object)accessDelegate, (Object)view);
            return false;
        }
        return true;
    }
}

