/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.navigator.internal;

import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.ui.UI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.vaadin.spring.internal.BeanStore;
import org.vaadin.spring.navigator.internal.ViewCache;

public class DefaultViewCache
implements ViewCache {
    private static final long serialVersionUID = 4634842615905376953L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultViewCache.class);
    private Map<String, ViewBeanStore> beanStores = new HashMap<String, ViewBeanStore>();
    private String viewUnderConstruction = null;
    private String activeView = null;

    @Override
    public void creatingView(String viewName) {
        LOGGER.trace("Creating view [{}] in cache [{}]", (Object)viewName, (Object)this);
        this.getOrCreateBeanStore(viewName);
        this.viewUnderConstruction = viewName;
    }

    @Override
    public void viewCreated(String viewName, View viewInstance) {
        LOGGER.trace("View [{}] created in cache [{}]", (Object)viewName, (Object)this);
        this.viewUnderConstruction = null;
        ViewBeanStore beanStore = this.getOrCreateBeanStore(viewName);
        if (viewInstance == null) {
            LOGGER.trace("There was a problem creating the view [{}] in cache [{)], destroying its bean store", (Object)viewName, (Object)this);
            beanStore.destroy();
        }
    }

    private void viewActivated(String viewName) {
        LOGGER.trace("View [{}] activated in cache [{}]", (Object)viewName, (Object)this);
        this.activeView = viewName;
    }

    private void viewDeactivated(String viewName) {
        LOGGER.trace("View [{}] deactivated in cache [{}], destroying its bean store", (Object)viewName, (Object)this);
        if (viewName.equals(this.activeView)) {
            this.activeView = null;
        }
        this.getBeanStore(viewName).destroy();
        LOGGER.trace("Bean stores stored in cache [{}]: {}", (Object)this, (Object)this.beanStores.size());
    }

    @Override
    public BeanStore getCurrentViewBeanStore() {
        if (this.viewUnderConstruction != null) {
            LOGGER.trace("Currently the view [{}] is under construction in cache [{}], returning its bean store", (Object)this.viewUnderConstruction, (Object)this);
            return this.getBeanStore(this.viewUnderConstruction);
        }
        if (this.activeView != null) {
            LOGGER.trace("Currently the view [{}] is active in cache [{}], returning its bean store", (Object)this.activeView, (Object)this);
            return this.getBeanStore(this.activeView);
        }
        throw new IllegalStateException("No active view");
    }

    @PreDestroy
    void destroy() {
        LOGGER.trace("View cache [{}] has been destroyed, destroying all bean stores");
        for (ViewBeanStore beanStore : new HashSet<ViewBeanStore>(this.beanStores.values())) {
            beanStore.destroy();
        }
        Assert.isTrue((boolean)this.beanStores.isEmpty(), (String)"beanStores should have been emptied by the destruction callbacks");
    }

    private ViewBeanStore getOrCreateBeanStore(final String viewName) {
        ViewBeanStore beanStore = this.beanStores.get(viewName);
        if (beanStore == null) {
            UI ui = this.getCurrentUI();
            if (ui == null) {
                throw new IllegalStateException("No UI bound to current thread");
            }
            beanStore = new ViewBeanStore(ui, viewName, new BeanStore.DestructionCallback(){
                private static final long serialVersionUID = 5580606280246825742L;

                @Override
                public void beanStoreDestroyed(BeanStore beanStore) {
                    DefaultViewCache.this.beanStores.remove(viewName);
                }
            });
            this.beanStores.put(viewName, beanStore);
        }
        return beanStore;
    }

    private UI getCurrentUI() {
        return UI.getCurrent();
    }

    private ViewBeanStore getBeanStore(String viewName) {
        ViewBeanStore beanStore = this.beanStores.get(viewName);
        if (beanStore == null) {
            throw new IllegalStateException("The view " + viewName + " has not been created");
        }
        return beanStore;
    }

    private class ViewBeanStore
    extends BeanStore
    implements ViewChangeListener {
        private static final long serialVersionUID = -7655740852919880134L;
        private final String viewName;
        private final Navigator navigator;

        private ViewBeanStore(UI ui, String viewName, BeanStore.DestructionCallback destructionCallback) {
            super(ui.getId() + ":" + viewName, destructionCallback);
            this.viewName = viewName;
            this.navigator = ui.getNavigator();
            if (this.navigator == null) {
                throw new IllegalStateException("UI has no Navigator");
            }
            LOGGER.trace("Adding [{}} as view change listener to [{}]", (Object)this, (Object)this.navigator);
            this.navigator.addViewChangeListener((ViewChangeListener)this);
        }

        @Override
        public void destroy() {
            LOGGER.trace("Removing [{}] as view change listener from [{}]", (Object)this, (Object)this.navigator);
            this.navigator.removeViewChangeListener((ViewChangeListener)this);
            super.destroy();
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent viewChangeEvent) {
            return true;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent viewChangeEvent) {
            if (this.viewName.equals(viewChangeEvent.getViewName())) {
                DefaultViewCache.this.viewActivated(this.viewName);
            } else {
                DefaultViewCache.this.viewDeactivated(this.viewName);
            }
        }
    }
}

