/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.navigator.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.Assert;
import org.vaadin.spring.navigator.internal.ViewCache;
import org.vaadin.spring.navigator.internal.ViewCacheRetrievalStrategy;

public class VaadinViewScope
implements Scope,
BeanFactoryPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaadinViewScope.class);
    public static final String VAADIN_VIEW_SCOPE_NAME = "vaadin-view";
    private static ViewCacheRetrievalStrategy viewCacheRetrievalStrategy = new BeanFactoryContextViewCacheRetrievalStrategy();
    private ConfigurableListableBeanFactory beanFactory;

    public static synchronized void setViewCacheRetrievalStrategy(ViewCacheRetrievalStrategy viewCacheRetrievalStrategy) {
        if (viewCacheRetrievalStrategy == null) {
            viewCacheRetrievalStrategy = new BeanFactoryContextViewCacheRetrievalStrategy();
        }
        VaadinViewScope.viewCacheRetrievalStrategy = viewCacheRetrievalStrategy;
    }

    public static synchronized ViewCacheRetrievalStrategy getViewCacheRetrievalStrategy() {
        return viewCacheRetrievalStrategy;
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        return this.getViewCache().getCurrentViewBeanStore().get(name, objectFactory);
    }

    public Object remove(String name) {
        return this.getViewCache().getCurrentViewBeanStore().remove(name);
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        this.getViewCache().getCurrentViewBeanStore().registerDestructionCallback(name, callback);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    private ViewCache getViewCache() {
        Assert.notNull((Object)this.beanFactory, (String)"beanFactory has not been set yet");
        return viewCacheRetrievalStrategy.getViewCache((BeanFactory)this.beanFactory);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        LOGGER.debug("Registering Vaadin View scope with bean factory [{}]", (Object)beanFactory);
        beanFactory.registerScope(VAADIN_VIEW_SCOPE_NAME, (Scope)this);
    }

    public static class BeanFactoryContextViewCacheRetrievalStrategy
    implements ViewCacheRetrievalStrategy {
        @Override
        public ViewCache getViewCache(BeanFactory beanFactory) {
            return (ViewCache)beanFactory.getBean(ViewCache.class);
        }
    }
}

