/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.servlet;

import com.vaadin.ui.UI;
import org.springframework.web.context.WebApplicationContext;
import org.vaadin.spring.annotation.VaadinUI;
import org.vaadin.spring.servlet.internal.AbstractSpringAwareUIProvider;

public class SpringAwareUIProvider
extends AbstractSpringAwareUIProvider {
    private static final long serialVersionUID = 6954428459733726004L;

    public SpringAwareUIProvider(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    @Override
    protected void detectUIs() {
        String[] uiBeanNames;
        this.logger.info("Checking the application context for Vaadin UIs");
        for (String uiBeanName : uiBeanNames = this.getWebApplicationContext().getBeanNamesForAnnotation(VaadinUI.class)) {
            Class beanType = this.getWebApplicationContext().getType(uiBeanName);
            if (!UI.class.isAssignableFrom(beanType)) continue;
            this.logger.info("Found Vaadin UI [{}]", (Object)beanType.getCanonicalName());
            String path = ((VaadinUI)this.getWebApplicationContext().findAnnotationOnBean(uiBeanName, VaadinUI.class)).path();
            Class<? extends UI> existingBeanType = this.getUIByPath(path);
            if (existingBeanType != null) {
                throw new IllegalStateException(String.format("[%s] is already mapped to the path [%s]", existingBeanType.getCanonicalName(), path));
            }
            this.logger.debug("Mapping Vaadin UI [{}] to path [{}]", (Object)beanType.getCanonicalName(), (Object)path);
            this.mapPathToUI(path, beanType);
        }
    }
}

