/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.servlet.internal;

import com.vaadin.server.UIClassSelectionEvent;
import com.vaadin.server.UICreateEvent;
import com.vaadin.server.UIProvider;
import com.vaadin.ui.UI;
import com.vaadin.util.CurrentInstance;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.vaadin.spring.internal.UIID;

public abstract class AbstractSpringAwareUIProvider
extends UIProvider {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final long serialVersionUID = -6195911893325385491L;
    private final WebApplicationContext webApplicationContext;
    private final Map<String, Class<? extends UI>> pathToUIMap = new ConcurrentHashMap<String, Class<? extends UI>>();
    private final Map<String, Class<? extends UI>> wildcardPathToUIMap = new ConcurrentHashMap<String, Class<? extends UI>>();

    public AbstractSpringAwareUIProvider(WebApplicationContext webApplicationContext) {
        this.webApplicationContext = webApplicationContext;
        this.detectUIs();
        if (this.pathToUIMap.isEmpty()) {
            this.logger.warn("Found no Vaadin UIs in the application context");
        }
    }

    protected abstract void detectUIs();

    public Class<? extends UI> getUIClass(UIClassSelectionEvent uiClassSelectionEvent) {
        String path = this.extractUIPathFromPathInfo(uiClassSelectionEvent.getRequest().getPathInfo());
        if (this.pathToUIMap.containsKey(path)) {
            return this.pathToUIMap.get(path);
        }
        for (Map.Entry<String, Class<? extends UI>> entry : this.wildcardPathToUIMap.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private String extractUIPathFromPathInfo(String pathInfo) {
        if (pathInfo != null && pathInfo.length() > 1) {
            String path = pathInfo;
            int indexOfBang = path.indexOf(33);
            if (indexOfBang > -1) {
                path = path.substring(0, indexOfBang);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        return "";
    }

    protected WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void mapPathToUI(String path, Class<? extends UI> uiClass) {
        if (path.endsWith("/*")) {
            this.wildcardPathToUIMap.put(path.substring(0, path.length() - 2), uiClass);
        } else {
            this.pathToUIMap.put(path, uiClass);
        }
    }

    protected Class<? extends UI> getUIByPath(String path) {
        return this.pathToUIMap.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UI createInstance(UICreateEvent event) {
        Class<UIID> key = UIID.class;
        UIID identifier = new UIID(event);
        CurrentInstance.set(key, (Object)identifier);
        try {
            this.logger.debug("Creating a new UI bean of class [{}] with identifier [{}]", (Object)event.getUIClass().getCanonicalName(), (Object)identifier);
            UI uI = (UI)this.webApplicationContext.getBean(event.getUIClass());
            return uI;
        }
        finally {
            CurrentInstance.set(key, null);
        }
    }
}

