/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.external;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**
* embedded file
*/
public interface EmbeddedFile extends External {
	

	/**
	* MIME type of the embedded file (/Subtype entry in the embedded file dictionary)
	*/
	public String getSubtype();

	/**
	* true if this file is a valid PDF/A document (Part 1 or Part 2) on its own
	*/
	public Boolean getisValidPDFA12();

	/**
	* true if this file is a valid PDF/A document (Part 1, Part 2 or Part 4) on its own
	*/
	public Boolean getisValidPDFA124();
}
