/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.xmplayer;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**
* Extension schema property definition
*/
public interface ExtensionSchemaProperty extends ExtensionSchemaObject {
	

	/**
	* category field value
	*/
	public String getcategory();

	/**
	* true if property category (’pdfaProperty:category’ property) is of type Text
	*/
	public Boolean getisCategoryValidText();

	/**
	* true if property description (’pdfaProperty:description’ property) is of type Text
	*/
	public Boolean getisDescriptionValidText();

	/**
	* true if property name (’pdfaProperty:name’ property) is of type Text
	*/
	public Boolean getisNameValidText();

	/**
	* true if property value type (’pdfaProperty:valueType’ property) is of type Text
	*/
	public Boolean getisValueTypeValidText();

	/**
	* true if property value type (’pdfaProperty:valueType’ property) is defined
	*/
	public Boolean getisValueTypeDefined();

	/**
	* namespace prefix for the category property
	*/
	public String getcategoryPrefix();

	/**
	* namespace prefix for the description property
	*/
	public String getdescriptionPrefix();

	/**
	* namespace prefix for the name property
	*/
	public String getnamePrefix();

	/**
	* namespace prefix for the value type property
	*/
	public String getvalueTypePrefix();
}
