'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions


require('../../../src/components/VChipGroup/VChipGroup.sass');

var _VSlideGroup = require('../VSlideGroup/VSlideGroup');

/* @vue/component */
exports.default = _VSlideGroup.BaseSlideGroup.extend({
    name: 'v-chip-group',
    provide: function provide() {
        return {
            chipGroup: this
        };
    },

    props: {
        activeClass: {
            type: String,
            default: 'grey lighten-1'
        },
        choice: Boolean,
        column: Boolean,
        outlined: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VSlideGroup.BaseSlideGroup.options.computed.classes.call(this), {
                'v-chip-group': true,
                'v-chip-group--column': this.column
            });
        }
    },
    watch: {
        column: function column(val) {
            if (val) this.scrollOffset = 0;
            this.$nextTick(this.onResize);
        }
    }
});
//# sourceMappingURL=VChipGroup.js.map