'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Lang = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _service = require('../service');

var _en = require('../../locale/en');

var _en2 = _interopRequireDefault(_en);

var _helpers = require('../../util/helpers');

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Extensions

// Language

// Utilities


var LANG_PREFIX = '$vuetify.';
var fallback = Symbol('Lang fallback');
function getTranslation(locale, key) {
    var usingFallback = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    var shortKey = key.replace(LANG_PREFIX, '');
    var translation = (0, _helpers.getObjectValueByPath)(locale, shortKey, fallback);
    if (translation === fallback) {
        if (usingFallback) {
            (0, _console.consoleError)('Translation key "' + shortKey + '" not found in fallback');
            translation = key;
        } else {
            (0, _console.consoleWarn)('Translation key "' + shortKey + '" not found, falling back to default');
            translation = getTranslation(_en2.default, key, true);
        }
    }
    return translation;
}

var Lang = exports.Lang = function (_Service) {
    _inherits(Lang, _Service);

    function Lang() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, Lang);

        var _this = _possibleConstructorReturn(this, (Lang.__proto__ || Object.getPrototypeOf(Lang)).call(this));

        _this.current = options.current || 'en';
        _this.locales = Object.assign({ en: _en2.default }, options.locales);
        _this.translator = options.t;
        return _this;
    }

    _createClass(Lang, [{
        key: 't',
        value: function t(key) {
            for (var _len = arguments.length, params = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                params[_key - 1] = arguments[_key];
            }

            if (!key.startsWith(LANG_PREFIX)) return key;
            if (this.translator) return this.translator.apply(this, [key].concat(params));
            var translation = getTranslation(this.locales[this.current], key);
            return translation.replace(/\{(\d+)\}/g, function (match, index) {
                /* istanbul ignore next */
                return String(params[+index]);
            });
        }
    }]);

    return Lang;
}(_service.Service);

Lang.property = 'lang';
//# sourceMappingURL=index.js.map