var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import mixins from '../../util/mixins';
import header from './mixins/header';
import { getTextAlignment } from '../../util/helpers';
export default mixins(header).extend({
    name: 'v-data-table-header-desktop',
    methods: {
        genGroupByToggle: function genGroupByToggle(header) {
            var _this = this;

            return this.$createElement('span', {
                on: {
                    click: function click() {
                        return _this.$emit('group', header.value);
                    }
                }
            }, ['group']);
        },
        genHeader: function genHeader(header) {
            var _this2 = this;

            var listeners = {};
            var children = [];
            var attrs = {
                role: 'columnheader',
                scope: 'col',
                'aria-label': header.text || '',
                'aria-sort': 'none'
            };
            var classes = _defineProperty({}, getTextAlignment(header.align, this.$vuetify.rtl), true);
            if (header.value === 'data-table-select') {
                children.push(this.genSelectAll());
            } else {
                children.push(this.$scopedSlots[header.value] ? this.$scopedSlots[header.value]({ header: header }) : this.$createElement('span', [header.text]));
                if (header.sortable || !header.hasOwnProperty('sortable')) {
                    listeners['click'] = function () {
                        return _this2.$emit('sort', header.value);
                    };
                    var sortIndex = this.options.sortBy.findIndex(function (k) {
                        return k === header.value;
                    });
                    var beingSorted = sortIndex >= 0;
                    var isDesc = this.options.sortDesc[sortIndex];
                    classes = _extends({}, classes, {
                        'sortable': true,
                        'active': beingSorted,
                        'asc': beingSorted && !isDesc,
                        'desc': beingSorted && isDesc
                    });
                    if (beingSorted) {
                        attrs['aria-sort'] = isDesc ? 'descending' : 'ascending';
                        attrs['aria-label'] += isDesc ? this.$vuetify.lang.t('$vuetify.dataTable.ariaLabel.sortDescending') : this.$vuetify.lang.t('$vuetify.dataTable.ariaLabel.sortAscending');
                    } else {
                        attrs['aria-label'] += this.$vuetify.lang.t('$vuetify.dataTable.ariaLabel.sortNone');
                    }
                    if (header.align === 'end') children.unshift(this.genSortIcon());else children.push(this.genSortIcon());
                    if (this.options.multiSort && beingSorted) {
                        children.push(this.$createElement('span', { class: 'v-data-table-header__sort-badge' }, [String(sortIndex + 1)]));
                    }
                }
                if (this.showGroupBy) {
                    children.push(this.genGroupByToggle(header));
                }
            }
            return this.$createElement('th', {
                attrs: attrs,
                class: classes,
                on: listeners
            }, children);
        }
    },
    render: function render() {
        var _this3 = this;

        return this.$createElement('thead', {
            staticClass: 'v-data-table-header'
        }, [this.$createElement('tr', this.headers.map(function (header) {
            return _this3.genHeader(header);
        }))]);
    }
});
//# sourceMappingURL=VDataTableHeaderDesktop.js.map