function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Types
import Vue from 'vue';
// Utils
import { getObjectValueByPath, getTextAlignment } from '../../util/helpers';
export default Vue.extend({
    name: 'v-row',
    functional: true,
    props: {
        headers: Array,
        item: Object,
        rtl: Boolean
    },
    render: function render(h, _ref) {
        var props = _ref.props,
            slots = _ref.slots,
            data = _ref.data;

        var computedSlots = slots();
        var columns = props.headers.map(function (header) {
            var classes = _defineProperty({}, getTextAlignment(header.align, props.rtl), true);
            var children = [];
            var value = getObjectValueByPath(props.item, header.value);
            var slotName = 'column.' + header.value;
            var scopedSlot = data.scopedSlots && data.scopedSlots[slotName];
            var regularSlot = computedSlots[slotName];
            if (scopedSlot) {
                children.push(scopedSlot({ item: props.item, header: header, value: value }));
            } else if (regularSlot) {
                children.push(regularSlot);
            } else {
                children.push(value);
            }
            return h('td', {
                class: classes
            }, children);
        });
        return h('tr', data, columns);
    }
});
//# sourceMappingURL=VRow.js.map