import { VExpandTransition } from '../transitions';
// Mixins
import Bootable from '../../mixins/bootable';
import { inject as RegistrableInject } from '../../mixins/registrable';
// Utilities
import { getSlot } from '../../util/helpers';
import mixins from '../../util/mixins';
var baseMixins = mixins(Bootable, RegistrableInject('expansionPanel', 'v-expansion-panel-content', 'v-expansion-panel'));
/* @vue/component */
export default baseMixins.extend().extend({
    name: 'v-expansion-panel-content',
    computed: {
        isActive: function isActive() {
            return this.expansionPanel.isActive;
        }
    },
    created: function created() {
        this.expansionPanel.registerContent(this);
    },
    beforeDestroy: function beforeDestroy() {
        this.expansionPanel.unregisterContent();
    },
    render: function render(h) {
        return h(VExpandTransition, [h('div', {
            staticClass: 'v-expansion-panel-content',
            directives: [{
                name: 'show',
                value: this.isActive
            }]
        }, this.showLazyContent([h('div', { class: 'v-expansion-panel-content__wrap' }, getSlot(this))]))]);
    }
});
//# sourceMappingURL=VExpansionPanelContent.js.map