/**
 * Menu activator
 *
 * @mixin
 *
 * Handles the click and hover activation
 * Supports slotted and detached activators
 */
/* @vue/component */
export default {
    methods: {
        activatorClickHandler: function activatorClickHandler(e) {
            if (this.openOnClick && !this.isActive) {
                this.getActivator(e).focus();
                this.isActive = true;
                this.absoluteX = e.clientX;
                this.absoluteY = e.clientY;
            } else if (this.closeOnClick && this.isActive) {
                this.getActivator(e).blur();
                this.isActive = false;
            }
        },
        mouseEnterHandler: function mouseEnterHandler() {
            var _this = this;

            this.runDelay('open', function () {
                if (_this.hasJustFocused) return;
                _this.hasJustFocused = true;
                _this.isActive = true;
            });
        },
        mouseLeaveHandler: function mouseLeaveHandler(e) {
            var _this2 = this;

            // Prevent accidental re-activation
            this.runDelay('close', function () {
                if (_this2.$refs.content.contains(e.relatedTarget)) return;
                requestAnimationFrame(function () {
                    _this2.isActive = false;
                    _this2.callDeactivate();
                });
            });
        },
        addActivatorEvents: function addActivatorEvents() {
            var activator = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

            if (!activator || this.disabled) return;
            activator.addEventListener('click', this.activatorClickHandler);
        },
        removeActivatorEvents: function removeActivatorEvents() {
            var activator = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

            if (!activator) return;
            activator.removeEventListener('click', this.activatorClickHandler);
        }
    }
};
//# sourceMappingURL=menu-activator.js.map