var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import Vue from 'vue';
import Ripple from '../../directives/ripple';
export default Vue.extend({
    name: 'routable',
    directives: {
        Ripple: Ripple
    },
    props: {
        activeClass: String,
        append: Boolean,
        disabled: Boolean,
        exact: {
            type: Boolean,
            default: undefined
        },
        exactActiveClass: String,
        href: [String, Object],
        to: [String, Object],
        nuxt: Boolean,
        replace: Boolean,
        ripple: [Boolean, Object],
        tag: String,
        target: String
    },
    computed: {
        computedRipple: function computedRipple() {
            return this.ripple && !this.disabled ? this.ripple : false;
        }
    },
    methods: {
        click: function click(e) {
            this.$emit('click', e);
        },
        generateRouteLink: function generateRouteLink(classes) {
            var styles = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

            var exact = this.exact;
            var tag = void 0;
            var data = _defineProperty({
                attrs: { disabled: this.disabled },
                class: classes,
                style: styles,
                props: {},
                directives: [{
                    name: 'ripple',
                    value: this.computedRipple
                }]
            }, this.to ? 'nativeOn' : 'on', _extends({}, this.$listeners, {
                click: this.click
            }));
            if (typeof this.exact === 'undefined') {
                exact = this.to === '/' || this.to === Object(this.to) && this.to.path === '/';
            }
            if (this.to) {
                // Add a special activeClass hook
                // for component level styles
                var activeClass = this.activeClass;
                var exactActiveClass = this.exactActiveClass || activeClass;
                // TODO: apply only in VListTile
                if (this.proxyClass) {
                    activeClass += ' ' + this.proxyClass;
                    exactActiveClass += ' ' + this.proxyClass;
                }
                tag = this.nuxt ? 'nuxt-link' : 'router-link';
                Object.assign(data.props, {
                    to: this.to,
                    exact: exact,
                    activeClass: activeClass,
                    exactActiveClass: exactActiveClass,
                    append: this.append,
                    replace: this.replace
                });
            } else {
                tag = this.href && 'a' || this.tag || 'div';
                if (tag === 'a' && this.href) data.attrs.href = this.href;
            }
            if (this.target) data.attrs.target = this.target;
            return { tag: tag, data: data };
        }
    }
});
//# sourceMappingURL=index.js.map