'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Directives

// Mixins

// Utilities


require('../../../src/components/VAppBar/VAppBar.sass');

var _VToolbar = require('../VToolbar/VToolbar');

var _VToolbar2 = _interopRequireDefault(_VToolbar);

var _scroll = require('../../directives/scroll');

var _scroll2 = _interopRequireDefault(_scroll);

var _applicationable = require('../../mixins/applicationable');

var _applicationable2 = _interopRequireDefault(_applicationable);

var _scrollable = require('../../mixins/scrollable');

var _scrollable2 = _interopRequireDefault(_scrollable);

var _ssrBootable = require('../../mixins/ssr-bootable');

var _ssrBootable2 = _interopRequireDefault(_ssrBootable);

var _toggleable = require('../../mixins/toggleable');

var _toggleable2 = _interopRequireDefault(_toggleable);

var _helpers = require('../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var baseMixins = (0, _mixins2.default)(_VToolbar2.default, _scrollable2.default, _ssrBootable2.default, _toggleable2.default, (0, _applicationable2.default)('top', ['clippedLeft', 'clippedRight', 'computedHeight', 'computedTransform', 'invertedScroll', 'isExtended', 'isProminent', 'value']));
/* @vue/component */
exports.default = baseMixins.extend({
    name: 'v-app-bar',
    directives: { Scroll: _scroll2.default },
    props: {
        clippedLeft: Boolean,
        clippedRight: Boolean,
        collapseOnScroll: Boolean,
        fadeImgOnScroll: Boolean,
        elevateOnScroll: Boolean,
        hideOnScroll: Boolean,
        invertedScroll: Boolean,
        scrollOffScreen: Boolean,
        shrinkOnScroll: Boolean,
        value: {
            type: Boolean,
            default: true
        }
    },
    data: function data() {
        return {
            isActive: this.value
        };
    },

    computed: {
        applicationProperty: function applicationProperty() {
            return !this.bottom ? 'top' : 'bottom';
        },
        canScroll: function canScroll() {
            return _scrollable2.default.options.computed.canScroll.call(this) && (this.invertedScroll || this.elevateOnScroll || this.hideOnScroll || this.collapseOnScroll || this.isBooted ||
            // If falsey, user has provided an
            // explicit value which should
            // overwrite anything we do
            !this.value);
        },
        classes: function classes() {
            return _extends({}, _VToolbar2.default.options.computed.classes.call(this), {
                'v-toolbar--collapse': this.collapse || this.collapseOnScroll,
                'v-app-bar': true,
                'v-app-bar--clipped': this.clippedLeft || this.clippedRight,
                'v-app-bar--fade-img-on-scroll': this.fadeImgOnScroll,
                'v-app-bar--elevate-on-scroll': this.elevateOnScroll,
                'v-app-bar--fixed': !this.absolute && (this.app || this.fixed),
                'v-app-bar--hide-shadow': this.hideShadow,
                'v-app-bar--is-scrolled': this.currentScroll > 0,
                'v-app-bar--shrink-on-scroll': this.shrinkOnScroll
            });
        },
        computedContentHeight: function computedContentHeight() {
            if (!this.shrinkOnScroll) return _VToolbar2.default.options.computed.computedContentHeight.call(this);
            var height = this.computedOriginalHeight;
            var min = this.dense ? 48 : 56;
            var max = height;
            var difference = max - min;
            var iteration = difference / this.computedScrollThreshold;
            var offset = this.currentScroll * iteration;
            return Math.max(min, max - offset);
        },
        computedFontSize: function computedFontSize() {
            if (!this.isProminent) return undefined;
            var max = this.dense ? 96 : 128;
            var difference = max - this.computedContentHeight;
            var increment = 0.00347;
            // 1.5rem to a minimum of 1.25rem
            return Number((1.50 - difference * increment).toFixed(2));
        },
        computedLeft: function computedLeft() {
            if (!this.app || this.clippedLeft) return 0;
            return this.$vuetify.application.left;
        },
        computedMarginTop: function computedMarginTop() {
            if (!this.app) return 0;
            return this.$vuetify.application.bar;
        },
        computedOpacity: function computedOpacity() {
            if (!this.fadeImgOnScroll) return undefined;
            var opacity = Math.max((this.computedScrollThreshold - this.currentScroll) / this.computedScrollThreshold, 0);
            return Number(parseFloat(opacity).toFixed(2));
        },
        computedOriginalHeight: function computedOriginalHeight() {
            var height = _VToolbar2.default.options.computed.computedContentHeight.call(this);
            if (this.isExtended) height += parseInt(this.extensionHeight);
            return height;
        },
        computedRight: function computedRight() {
            if (!this.app || this.clippedRight) return 0;
            return this.$vuetify.application.right;
        },
        computedScrollThreshold: function computedScrollThreshold() {
            if (this.scrollThreshold) return Number(this.scrollThreshold);
            return this.computedOriginalHeight - (this.dense ? 48 : 56);
        },
        computedTransform: function computedTransform() {
            if (!this.canScroll || this.elevateOnScroll && this.currentScroll === 0) return 0;
            if (this.isActive) return 0;
            return this.scrollOffScreen ? -this.computedHeight : -this.computedContentHeight;
        },
        hideShadow: function hideShadow() {
            if (this.elevateOnScroll) {
                return this.currentScroll === 0 || this.computedTransform < 0;
            }
            return (!this.isExtended || this.scrollOffScreen) && this.computedTransform !== 0;
        },
        isCollapsed: function isCollapsed() {
            if (!this.collapseOnScroll) {
                return _VToolbar2.default.options.computed.isCollapsed.call(this);
            }
            return this.currentScroll > 0;
        },
        isProminent: function isProminent() {
            return _VToolbar2.default.options.computed.isProminent.call(this) || this.shrinkOnScroll;
        },
        styles: function styles() {
            return _extends({}, _VToolbar2.default.options.computed.styles.call(this), {
                fontSize: (0, _helpers.convertToUnit)(this.computedFontSize, 'rem'),
                marginTop: (0, _helpers.convertToUnit)(this.computedMarginTop),
                transform: 'translateY(' + (0, _helpers.convertToUnit)(this.computedTransform) + ')',
                left: (0, _helpers.convertToUnit)(this.computedLeft),
                right: (0, _helpers.convertToUnit)(this.computedRight)
            });
        }
    },
    watch: {
        canScroll: 'onScroll',
        invertedScroll: function invertedScroll(val) {
            this.isActive = !val;
        }
    },
    created: function created() {
        if (this.invertedScroll) this.isActive = false;
    },

    methods: {
        genBackground: function genBackground() {
            var render = _VToolbar2.default.options.methods.genBackground.call(this);
            render.data = this._b(render.data || {}, render.tag, {
                style: { opacity: this.computedOpacity }
            });
            return render;
        },
        updateApplication: function updateApplication() {
            return this.invertedScroll ? 0 : this.computedHeight + this.computedTransform;
        },
        thresholdMet: function thresholdMet() {
            if (this.invertedScroll) {
                this.isActive = this.currentScroll > this.computedScrollThreshold;
                return;
            }
            if (this.currentThreshold < this.computedScrollThreshold) return;
            if (this.hideOnScroll) {
                this.isActive = this.isScrollingUp;
            }
            this.savedScroll = this.currentScroll;
        }
    },
    render: function render(h) {
        var render = _VToolbar2.default.options.render.call(this, h);
        render.data = render.data || {};
        if (this.canScroll) {
            render.data.directives = render.data.directives || [];
            render.data.directives.push({
                arg: this.scrollTarget,
                name: 'scroll',
                value: this.onScroll
            });
        }
        return render;
    }
});
//# sourceMappingURL=VAppBar.js.map