'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Components

// Mixins

// Directives

// Utilities


require('../../../src/components/VChip/VChip.sass');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _transitions = require('../transitions');

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _groupable = require('../../mixins/groupable');

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _toggleable = require('../../mixins/toggleable');

var _sizeable = require('../../mixins/sizeable');

var _sizeable2 = _interopRequireDefault(_sizeable);

var _ripple = require('../../directives/ripple');

var _ripple2 = _interopRequireDefault(_ripple);

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_colorable2.default, (0, _groupable.factory)('chipGroup'), _sizeable2.default, _themeable2.default, (0, _toggleable.factory)('inputValue')).extend({
    name: 'v-chip',
    directives: { Ripple: _ripple2.default },
    props: {
        close: Boolean,
        closeIcon: {
            type: String,
            default: '$vuetify.icons.delete'
        },
        disabled: Boolean,
        draggable: Boolean,
        filter: Boolean,
        filterIcon: {
            type: String,
            default: '$vuetify.icons.complete'
        },
        label: Boolean,
        link: Boolean,
        outline: Boolean,
        outlined: Boolean,
        pill: Boolean,
        ripple: {
            type: [Boolean, Object],
            default: null
        },
        // Used for selects/tagging
        selected: Boolean,
        textColor: String,
        value: null
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-chip--clickable': this.isClickable,
                'v-chip--disabled': this.disabled,
                'v-chip--draggable': this.draggable,
                'v-chip--label': this.label,
                'v-chip--no-color': !this.color,
                'v-chip--outlined': this.hasOutline,
                'v-chip--pill': this.pill,
                'v-chip--removable': this.hasClose,
                'v-chip--selected': !this.disabled && this.isActive
            }, this.themeClasses, this.sizeableClasses, this.groupClasses);
        },
        hasClose: function hasClose() {
            return Boolean(this.close || this.$listeners['click:close']);
        },
        hasOutline: function hasOutline() {
            return this.outline || this.outlined;
        },
        isClickable: function isClickable() {
            return Boolean(this.link || this.chipGroup || this.$listeners.click || this.$listeners['!click'] || this.$attrs.tabindex);
        }
    },
    methods: {
        genFilter: function genFilter() {
            var children = [];
            if (this.isActive) {
                children.push(this.$createElement(_VIcon2.default, {
                    staticClass: 'v-chip__filter',
                    props: { left: true }
                }, this.filterIcon));
            }
            return this.$createElement(_transitions.VExpandXTransition, children);
        },
        genClose: function genClose() {
            var _this = this;

            return this.$createElement(_VIcon2.default, {
                staticClass: 'v-chip__close',
                props: {
                    right: true
                },
                on: {
                    click: function click(e) {
                        e.stopPropagation();
                        _this.$emit('click:close');
                    }
                }
            }, this.closeIcon);
        },
        genContent: function genContent() {
            return this.$createElement('span', {
                staticClass: 'v-chip__content'
            }, [this.filter && this.genFilter(), this.$slots.default, this.hasClose && this.genClose()]);
        }
    },
    created: function created() {
        if (this.outline) (0, _console.deprecate)('outline', 'outlined', this);
        if (this.selected) (0, _console.deprecate)('selected', 'value', this);
    },
    render: function render(h) {
        var data = this.setBackgroundColor(this.color, {
            staticClass: 'v-chip',
            class: this.classes,
            attrs: _extends({}, this.$attrs, {
                draggable: this.draggable ? 'true' : undefined,
                tabindex: this.disabled ? -1 : this.$attrs.tabindex || +this.isClickable - 1
            }),
            directives: [{
                name: 'ripple',
                value: this.ripple != null ? this.ripple : !this.disabled
            }],
            on: this.$listeners
        });
        var color = this.textColor || this.hasOutline && this.color;
        if (!this.disabled && this.chipGroup) {
            this._g(data, { click: this.toggle });
        }
        return h('span', this.setTextColor(color, data), [this.genContent()]);
    }
});
//# sourceMappingURL=VChip.js.map