'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Components


require('../../../src/components/VList/VList.sass');

var _VSheet = require('../VSheet/VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = _VSheet2.default.extend({
    name: 'v-list',
    provide: function provide() {
        return {
            list: this
        };
    },

    props: {
        dense: Boolean,
        disabled: Boolean,
        expand: Boolean,
        flat: Boolean,
        nav: Boolean,
        rounded: Boolean,
        shaped: Boolean,
        subheader: Boolean,
        threeLine: Boolean,
        tile: {
            type: Boolean,
            default: true
        },
        twoLine: Boolean
    },
    data: function data() {
        return {
            groups: []
        };
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VSheet2.default.options.computed.classes.call(this), {
                'v-list--dense': this.dense,
                'v-list--disabled': this.disabled,
                'v-list--flat': this.flat,
                'v-list--nav': this.nav,
                'v-list--rounded': this.rounded,
                'v-list--shaped': this.shaped,
                'v-list--subheader': this.subheader,
                'v-list--two-line': this.twoLine,
                'v-list--three-line': this.threeLine
            });
        }
    },
    methods: {
        register: function register(content) {
            this.groups.push(content);
        },
        unregister: function unregister(content) {
            var index = this.groups.findIndex(function (g) {
                return g._uid === content._uid;
            });
            if (index > -1) this.groups.splice(index, 1);
        },
        listClick: function listClick(uid) {
            if (this.expand) return;
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = this.groups[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var group = _step.value;

                    group.toggle(uid);
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
        }
    },
    render: function render(h) {
        var data = {
            staticClass: 'v-list',
            class: this.classes,
            attrs: {
                role: 'list'
            }
        };
        return h('div', this.setBackgroundColor(this.color, data), [this.$slots.default]);
    }
});
//# sourceMappingURL=VList.js.map