'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Directives

// Utilities

// Types


require('../../../src/components/VList/VListItem.sass');

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _routable = require('../../mixins/routable');

var _routable2 = _interopRequireDefault(_routable);

var _groupable = require('../../mixins/groupable');

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _ripple = require('../../directives/ripple');

var _ripple2 = _interopRequireDefault(_ripple);

var _helpers = require('./../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var baseMixins = (0, _mixins2.default)(_colorable2.default, (0, _groupable.factory)('listItemGroup'), _routable2.default, _themeable2.default);
/* @vue/component */
exports.default = baseMixins.extend().extend({
    name: 'v-list-item',
    directives: {
        Ripple: _ripple2.default
    },
    inheritAttrs: false,
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.listItemGroup) return 'primary--text';
                return this.listItemGroup.activeClass;
            }
        },
        dense: Boolean,
        inactive: Boolean,
        link: Boolean,
        ripple: {
            type: [Boolean, Object],
            default: null
        },
        threeLine: Boolean,
        twoLine: Boolean,
        value: { default: null }
    },
    data: function data() {
        return {
            proxyClass: 'v-list-item--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-list-item': true,
                'v-list-item--active': this.isActive,
                'v-list-item--dense': this.dense,
                'v-list-item--disabled': this.disabled,
                'v-list-item--link': this.isLink && !this.inactive,
                'v-list-item--three-line': this.threeLine,
                'v-list-item--two-line': this.twoLine
            }, this.themeClasses, _defineProperty({}, this.activeClass, this.isActive));
        },
        computedRipple: function computedRipple() {
            if (this.disabled) return false;
            return this.ripple !== null ? this.ripple : this.isLink;
        },
        isLink: function isLink() {
            var hasClick = this.$listeners && (this.$listeners.click || this.$listeners['!click']);
            return Boolean(this.href || this.to || this.listItemGroup || this.link || hasClick);
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if ('avatar' in this.$attrs) {
            (0, _console.removed)('avatar', this);
        }
    },

    methods: {
        click: function click(e) {
            if (e.detail) this.$el.blur();
            this.$emit('click', e);
            this.to || this.toggle();
        }
    },
    render: function render(h) {
        var _this = this;

        var isRouteLink = !this.inactive && this.isLink;

        var _ref = isRouteLink ? this.generateRouteLink(this.classes) : {
            tag: this.tag || 'div',
            data: {
                class: this.classes
            }
        },
            tag = _ref.tag,
            data = _ref.data;

        data.attrs = _extends({}, data.attrs, {
            'aria-selected': String(this.isActive),
            role: 'listitem',
            tabindex: tag === 'a' ? 0 : -1
        });
        data.on = _extends({}, data.on, {
            click: this.click,
            keydown: function keydown(e) {
                /* istanbul ignore else */
                if (e.keyCode === _helpers.keyCodes.enter) _this.click(e);
                _this.$emit('keydown', e);
            }
        });
        data.ref = 'link';
        var children = this.$scopedSlots.default ? this.$scopedSlots.default({
            active: this.isActive,
            toggle: this.toggle
        }) : this.$slots.default;
        return h(tag, this.setBackgroundColor(this.color, data), children);
    }
});
//# sourceMappingURL=VListItem.js.map