var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VCard/VCard.sass';
// Extensions
import VSheet from '../VSheet';
// Mixins
import Loadable from '../../mixins/loadable';
import Routable from '../../mixins/routable';
// Helpers
import mixins from '../../util/mixins';
/* @vue/component */
export default mixins(Loadable, Routable, VSheet).extend({
    name: 'v-card',
    props: {
        flat: Boolean,
        hover: Boolean,
        img: String,
        link: Boolean,
        loaderHeight: {
            type: [Number, String],
            default: 4
        },
        outlined: Boolean,
        raised: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-card': true,
                'v-card--flat': this.flat,
                'v-card--hover': this.hover,
                'v-card--link': this.isLink,
                'v-card--disabled': this.loading || this.disabled,
                'v-card--outlined': this.outlined,
                'v-card--raised': this.raised
            }, VSheet.options.computed.classes.call(this));
        },
        isLink: function isLink() {
            var hasClick = this.$listeners && (this.$listeners.click || this.$listeners['!click']);
            return Boolean(this.href || this.to || this.link || hasClick);
        },
        styles: function styles() {
            var style = _extends({}, VSheet.options.computed.styles.call(this));
            if (this.img) {
                style.background = 'url("' + this.img + '") center center / cover no-repeat';
            }
            return style;
        }
    },
    methods: {
        genProgress: function genProgress() {
            var render = Loadable.options.methods.genProgress.call(this);
            if (!render) return null;
            return this.$createElement('div', {
                staticClass: 'v-card__progress'
            }, [render]);
        }
    },
    render: function render(h) {
        var _generateRouteLink = this.generateRouteLink(this.classes),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        data.style = this.styles;
        if (this.isLink) {
            data.attrs = data.attrs || {};
            data.attrs.tabindex = 0;
        }
        return h(tag, this.setBackgroundColor(this.color, data), [this.genProgress(), this.$slots.default]);
    }
});
//# sourceMappingURL=VCard.js.map