var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VChip/VChip.sass';
import mixins from '../../util/mixins';
// Components
import { VExpandXTransition } from '../transitions';
import VIcon from '../VIcon';
// Mixins
import Colorable from '../../mixins/colorable';
import { factory as GroupableFactory } from '../../mixins/groupable';
import Themeable from '../../mixins/themeable';
import { factory as ToggleableFactory } from '../../mixins/toggleable';
import Sizeable from '../../mixins/sizeable';
// Directives
import Ripple from '../../directives/ripple';
// Utilities
import { deprecate } from '../../util/console';
/* @vue/component */
export default mixins(Colorable, GroupableFactory('chipGroup'), Sizeable, Themeable, ToggleableFactory('inputValue')).extend({
    name: 'v-chip',
    directives: { Ripple: Ripple },
    props: {
        close: Boolean,
        closeIcon: {
            type: String,
            default: '$vuetify.icons.delete'
        },
        disabled: Boolean,
        draggable: Boolean,
        filter: Boolean,
        filterIcon: {
            type: String,
            default: '$vuetify.icons.complete'
        },
        label: Boolean,
        link: Boolean,
        outline: Boolean,
        outlined: Boolean,
        pill: Boolean,
        ripple: {
            type: [Boolean, Object],
            default: null
        },
        // Used for selects/tagging
        selected: Boolean,
        textColor: String,
        value: null
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-chip--clickable': this.isClickable,
                'v-chip--disabled': this.disabled,
                'v-chip--draggable': this.draggable,
                'v-chip--label': this.label,
                'v-chip--no-color': !this.color,
                'v-chip--outlined': this.hasOutline,
                'v-chip--pill': this.pill,
                'v-chip--removable': this.hasClose,
                'v-chip--selected': !this.disabled && this.isActive
            }, this.themeClasses, this.sizeableClasses, this.groupClasses);
        },
        hasClose: function hasClose() {
            return Boolean(this.close || this.$listeners['click:close']);
        },
        hasOutline: function hasOutline() {
            return this.outline || this.outlined;
        },
        isClickable: function isClickable() {
            return Boolean(this.link || this.chipGroup || this.$listeners.click || this.$listeners['!click'] || this.$attrs.tabindex);
        }
    },
    methods: {
        genFilter: function genFilter() {
            var children = [];
            if (this.isActive) {
                children.push(this.$createElement(VIcon, {
                    staticClass: 'v-chip__filter',
                    props: { left: true }
                }, this.filterIcon));
            }
            return this.$createElement(VExpandXTransition, children);
        },
        genClose: function genClose() {
            var _this = this;

            return this.$createElement(VIcon, {
                staticClass: 'v-chip__close',
                props: {
                    right: true
                },
                on: {
                    click: function click(e) {
                        e.stopPropagation();
                        _this.$emit('click:close');
                    }
                }
            }, this.closeIcon);
        },
        genContent: function genContent() {
            return this.$createElement('span', {
                staticClass: 'v-chip__content'
            }, [this.filter && this.genFilter(), this.$slots.default, this.hasClose && this.genClose()]);
        }
    },
    created: function created() {
        if (this.outline) deprecate('outline', 'outlined', this);
        if (this.selected) deprecate('selected', 'value', this);
    },
    render: function render(h) {
        var data = this.setBackgroundColor(this.color, {
            staticClass: 'v-chip',
            class: this.classes,
            attrs: _extends({}, this.$attrs, {
                draggable: this.draggable ? 'true' : undefined,
                tabindex: this.disabled ? -1 : this.$attrs.tabindex || +this.isClickable - 1
            }),
            directives: [{
                name: 'ripple',
                value: this.ripple != null ? this.ripple : !this.disabled
            }],
            on: this.$listeners
        });
        var color = this.textColor || this.hasOutline && this.color;
        if (!this.disabled && this.chipGroup) {
            this._g(data, { click: this.toggle });
        }
        return h('span', this.setTextColor(color, data), [this.genContent()]);
    }
});
//# sourceMappingURL=VChip.js.map