function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import '../../../src/components/VTooltip/VTooltip.sass';
// Mixins
import Colorable from '../../mixins/colorable';
import Delayable from '../../mixins/delayable';
import Dependent from '../../mixins/dependent';
import Detachable from '../../mixins/detachable';
import Menuable from '../../mixins/menuable';
import Toggleable from '../../mixins/toggleable';
// Helpers
import { convertToUnit, keyCodes, getSlotType } from '../../util/helpers';
import { consoleError } from '../../util/console';
import mixins from '../../util/mixins';
/* @vue/component */
export default mixins(Colorable, Delayable, Dependent, Detachable, Menuable, Toggleable).extend({
    name: 'v-tooltip',
    props: {
        closeDelay: {
            type: [Number, String],
            default: 0
        },
        debounce: {
            type: [Number, String],
            default: 0
        },
        disabled: Boolean,
        fixed: {
            type: Boolean,
            default: true
        },
        openDelay: {
            type: [Number, String],
            default: 0
        },
        tag: {
            type: String,
            default: 'span'
        },
        transition: String,
        zIndex: {
            default: null
        }
    },
    data: function data() {
        return {
            calculatedMinWidth: 0,
            closeDependents: false
        };
    },
    computed: {
        calculatedLeft: function calculatedLeft() {
            var _dimensions = this.dimensions,
                activator = _dimensions.activator,
                content = _dimensions.content;

            var unknown = !this.bottom && !this.left && !this.top && !this.right;
            var activatorLeft = this.isAttached ? activator.offsetLeft : activator.left;
            var left = 0;
            if (this.top || this.bottom || unknown) {
                left = activatorLeft + activator.width / 2 - content.width / 2;
            } else if (this.left || this.right) {
                left = activatorLeft + (this.right ? activator.width : -content.width) + (this.right ? 10 : -10);
            }
            if (this.nudgeLeft) left -= parseInt(this.nudgeLeft);
            if (this.nudgeRight) left += parseInt(this.nudgeRight);
            return this.calcXOverflow(left, this.dimensions.content.width) + 'px';
        },
        calculatedTop: function calculatedTop() {
            var _dimensions2 = this.dimensions,
                activator = _dimensions2.activator,
                content = _dimensions2.content;

            var activatorTop = this.isAttached ? activator.offsetTop : activator.top;
            var top = 0;
            if (this.top || this.bottom) {
                top = activatorTop + (this.bottom ? activator.height : -content.height) + (this.bottom ? 10 : -10);
            } else if (this.left || this.right) {
                top = activatorTop + activator.height / 2 - content.height / 2;
            }
            if (this.nudgeTop) top -= parseInt(this.nudgeTop);
            if (this.nudgeBottom) top += parseInt(this.nudgeBottom);
            return this.calcYOverflow(top + this.pageYOffset) + 'px';
        },
        classes: function classes() {
            return {
                'v-tooltip--top': this.top,
                'v-tooltip--right': this.right,
                'v-tooltip--bottom': this.bottom,
                'v-tooltip--left': this.left
            };
        },
        computedTransition: function computedTransition() {
            if (this.transition) return this.transition;
            return this.isActive ? 'scale-transition' : 'fade-transition';
        },
        offsetY: function offsetY() {
            return this.top || this.bottom;
        },
        offsetX: function offsetX() {
            return this.left || this.right;
        },
        styles: function styles() {
            return {
                left: this.calculatedLeft,
                maxWidth: convertToUnit(this.maxWidth),
                minWidth: convertToUnit(this.minWidth),
                opacity: this.isActive ? 0.9 : 0,
                top: this.calculatedTop,
                zIndex: this.zIndex || this.activeZIndex
            };
        }
    },
    beforeMount: function beforeMount() {
        var _this = this;

        this.$nextTick(function () {
            _this.value && _this.callActivate();
        });
    },
    mounted: function mounted() {
        if (getSlotType(this, 'activator', true) === 'v-slot') {
            consoleError('v-tooltip\'s activator slot must be bound, try \'<template #activator="data"><v-btn v-on="data.on>\'', this);
        }
    },

    methods: {
        activate: function activate() {
            // Update coordinates and dimensions of menu
            // and its activator
            this.updateDimensions();
            // Start the transition
            requestAnimationFrame(this.startTransition);
        },
        deactivate: function deactivate() {
            this.runDelay('close');
        },
        genActivator: function genActivator() {
            var _this2 = this;

            var listeners = this.disabled ? undefined : {
                mouseenter: function mouseenter(e) {
                    _this2.getActivator(e);
                    _this2.runDelay('open');
                },
                focus: function focus(e) {
                    _this2.getActivator(e);
                    _this2.runDelay('open');
                },
                mouseleave: function mouseleave(e) {
                    _this2.getActivator(e);
                    _this2.runDelay('close');
                },
                blur: function blur(e) {
                    _this2.getActivator(e);
                    _this2.runDelay('close');
                },
                keydown: function keydown(e) {
                    if (e.keyCode === keyCodes.esc) {
                        _this2.getActivator(e);
                        _this2.runDelay('close');
                    }
                }
            };
            if (getSlotType(this, 'activator') === 'scoped') {
                var activator = this.$scopedSlots.activator({ on: listeners });
                this.activatorNode = activator || null;
                return activator;
            }
            return this.$createElement('span', {
                on: listeners,
                ref: 'activator'
            }, this.$slots.activator);
        }
    },
    render: function render(h) {
        var _class;

        var tooltip = h('div', this.setBackgroundColor(this.color, {
            staticClass: 'v-tooltip__content',
            'class': (_class = {}, _defineProperty(_class, this.contentClass, true), _defineProperty(_class, 'menuable__content__active', this.isActive), _defineProperty(_class, 'v-tooltip__content--fixed', this.activatorFixed), _class),
            style: this.styles,
            attrs: this.getScopeIdAttrs(),
            directives: [{
                name: 'show',
                value: this.isContentActive
            }],
            ref: 'content'
        }), this.showLazyContent(this.$slots.default));
        return h(this.tag, {
            staticClass: 'v-tooltip',
            'class': this.classes
        }, [h('transition', {
            props: {
                name: this.computedTransition
            }
        }, [tooltip]), this.genActivator()]);
    }
});
//# sourceMappingURL=VTooltip.js.map