// Mixins
import Bootable from '../../mixins/bootable';
import { factory as GroupableFactory } from '../../mixins/groupable';
// Directives
import Touch from '../../directives/touch';
// Utilities
import { convertToUnit } from '../../util/helpers';
import mixins from '../../util/mixins';
var baseMixins = mixins(Bootable, GroupableFactory('windowGroup', 'v-window-item', 'v-window'));
export default baseMixins.extend().extend().extend({
    name: 'v-window-item',
    directives: {
        Touch: Touch
    },
    props: {
        disabled: Boolean,
        reverseTransition: {
            type: [Boolean, String],
            default: undefined
        },
        transition: {
            type: [Boolean, String],
            default: undefined
        },
        value: {
            required: false
        }
    },
    data: function data() {
        return {
            done: null,
            isActive: false,
            wasCancelled: false
        };
    },

    computed: {
        classes: function classes() {
            return this.groupClasses;
        },
        computedTransition: function computedTransition() {
            if (!this.windowGroup.internalReverse) {
                return typeof this.transition !== 'undefined' ? this.transition || '' : this.windowGroup.computedTransition;
            }
            return typeof this.reverseTransition !== 'undefined' ? this.reverseTransition || '' : this.windowGroup.computedTransition;
        }
    },
    mounted: function mounted() {
        this.$el.addEventListener('transitionend', this.onTransitionEnd, false);
    },
    beforeDestroy: function beforeDestroy() {
        this.$el.removeEventListener('transitionend', this.onTransitionEnd, false);
    },

    methods: {
        genDefaultSlot: function genDefaultSlot() {
            return this.$slots.default;
        },
        genWindowItem: function genWindowItem() {
            return this.$createElement('div', {
                staticClass: 'v-window-item',
                class: this.classes,
                directives: [{
                    name: 'show',
                    value: this.isActive
                }],
                on: this.$listeners
            }, this.showLazyContent(this.genDefaultSlot()));
        },
        onAfterEnter: function onAfterEnter() {
            var _this = this;

            if (this.wasCancelled) {
                this.wasCancelled = false;
                return;
            }
            requestAnimationFrame(function () {
                _this.windowGroup.internalHeight = undefined;
                _this.windowGroup.isActive = false;
            });
        },
        onBeforeEnter: function onBeforeEnter() {
            this.windowGroup.isActive = true;
        },
        onLeave: function onLeave(el) {
            this.windowGroup.internalHeight = convertToUnit(el.clientHeight);
        },
        onEnterCancelled: function onEnterCancelled() {
            this.wasCancelled = true;
        },
        onEnter: function onEnter(el, done) {
            var _this2 = this;

            var isBooted = this.windowGroup.isBooted;
            if (isBooted) this.done = done;
            requestAnimationFrame(function () {
                if (!_this2.computedTransition) return done();
                _this2.windowGroup.internalHeight = convertToUnit(el.clientHeight);
                // On initial render, there is no transition
                // Vue leaves a `enter` transition class
                // if done is called too fast
                !isBooted && setTimeout(done, 100);
            });
        },
        onTransitionEnd: function onTransitionEnd(e) {
            // This ensures we only call done
            // when the element transform
            // completes
            if (e.propertyName !== 'transform' || e.target !== this.$el || !this.done) return;
            this.done();
            this.done = null;
        }
    },
    render: function render(h) {
        return h('transition', {
            props: {
                name: this.computedTransition
            },
            on: {
                afterEnter: this.onAfterEnter,
                beforeEnter: this.onBeforeEnter,
                leave: this.onLeave,
                enter: this.onEnter,
                enterCancelled: this.onEnterCancelled
            }
        }, [this.genWindowItem()]);
    }
});
//# sourceMappingURL=VWindowItem.js.map