'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Utilities


exports.fromHSVA = fromHSVA;
exports.fromHSLA = fromHSLA;
exports.fromRGBA = fromRGBA;
exports.fromHexa = fromHexa;
exports.fromHex = fromHex;
exports.parseColor = parseColor;
exports.extractColor = extractColor;

var _colorUtils = require('../../../util/colorUtils');

function fromHSVA(hsva) {
    hsva = _extends({}, hsva);
    var hexa = (0, _colorUtils.HSVAtoHex)(hsva);
    return {
        alpha: hsva.a,
        hex: hexa.substr(0, 7),
        hexa: hexa,
        hsla: (0, _colorUtils.HSVAtoHSLA)(hsva),
        hsva: hsva,
        hue: hsva.h,
        rgba: (0, _colorUtils.HSVAtoRGBA)(hsva)
    };
}
function fromHSLA(hsla) {
    var hsva = (0, _colorUtils.HSLAtoHSVA)(hsla);
    var hexa = (0, _colorUtils.HSVAtoHex)(hsva);
    return {
        alpha: hsva.a,
        hex: hexa.substr(0, 7),
        hexa: hexa,
        hsla: hsla,
        hsva: hsva,
        hue: hsva.h,
        rgba: (0, _colorUtils.HSVAtoRGBA)(hsva)
    };
}
function fromRGBA(rgba) {
    var hsva = (0, _colorUtils.RGBAtoHSVA)(rgba);
    var hexa = (0, _colorUtils.RGBAtoHex)(rgba);
    return {
        alpha: hsva.a,
        hex: hexa.substr(0, 7),
        hexa: hexa,
        hsla: (0, _colorUtils.HSVAtoHSLA)(hsva),
        hsva: hsva,
        hue: hsva.h,
        rgba: rgba
    };
}
function fromHexa(hexa) {
    var hsva = (0, _colorUtils.HexToHSVA)(hexa);
    return {
        alpha: hsva.a,
        hex: hexa.substr(0, 7),
        hexa: hexa,
        hsla: (0, _colorUtils.HSVAtoHSLA)(hsva),
        hsva: hsva,
        hue: hsva.h,
        rgba: (0, _colorUtils.HSVAtoRGBA)(hsva)
    };
}
function fromHex(hex) {
    return fromHexa((0, _colorUtils.parseHex)(hex));
}
function has(obj, key) {
    return key.every(function (k) {
        return obj.hasOwnProperty(k);
    });
}
function parseColor(color, oldColor) {
    if (!color) return fromRGBA({ r: 255, g: 0, b: 0, a: 1 });
    if (typeof color === 'string') {
        if (color === 'transparent') return fromHexa('#00000000');
        var hex = (0, _colorUtils.parseHex)(color);
        if (oldColor && hex === oldColor.hexa) return oldColor;else return fromHexa(hex);
    }
    if ((typeof color === 'undefined' ? 'undefined' : _typeof(color)) === 'object') {
        if (color.hasOwnProperty('alpha')) return color;
        var a = color.hasOwnProperty('a') ? parseFloat(color.a) : 1;
        if (has(color, ['r', 'g', 'b'])) {
            if (oldColor && color === oldColor.rgba) return oldColor;else return fromRGBA(_extends({}, color, { a: a }));
        } else if (has(color, ['h', 's', 'l'])) {
            if (oldColor && color === oldColor.hsla) return oldColor;else return fromHSLA(_extends({}, color, { a: a }));
        } else if (has(color, ['h', 's', 'v'])) {
            if (oldColor && color === oldColor.hsva) return oldColor;else return fromHSVA(_extends({}, color, { a: a }));
        }
    }
    return fromRGBA({ r: 255, g: 0, b: 0, a: 1 });
}
function extractColor(color, input) {
    if (typeof input === 'string') {
        return input.length === 7 ? color.hex : color.hexa;
    }
    if ((typeof input === 'undefined' ? 'undefined' : _typeof(input)) === 'object') {
        if (has(input, ['r', 'g', 'b'])) return color.rgba;else if (has(input, ['h', 's', 'l'])) return color.hsla;else if (has(input, ['h', 's', 'v'])) return color.hsva;
    }
    return color;
}
//# sourceMappingURL=index.js.map