'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

require('../../../src/components/VDataIterator/VDataFooter.sass');

var _VSelect = require('../VSelect/VSelect');

var _VSelect2 = _interopRequireDefault(_VSelect);

var _VIcon = require('../VIcon');

var _VIcon2 = _interopRequireDefault(_VIcon);

var _VBtn = require('../VBtn');

var _VBtn2 = _interopRequireDefault(_VBtn);

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Components
exports.default = _vue2.default.extend({
    name: 'v-data-footer',
    props: {
        options: {
            type: Object,
            required: true
        },
        pagination: {
            type: Object,
            required: true
        },
        itemsPerPageOptions: {
            type: Array,
            default: function _default() {
                return [5, 10, 15, -1];
            }
        },
        prevIcon: {
            type: String,
            default: '$vuetify.icons.prev'
        },
        nextIcon: {
            type: String,
            default: '$vuetify.icons.next'
        },
        firstIcon: {
            type: String,
            default: '$vuetify.icons.first'
        },
        lastIcon: {
            type: String,
            default: '$vuetify.icons.last'
        },
        itemsPerPageText: {
            type: String,
            default: '$vuetify.dataFooter.itemsPerPageText'
        },
        itemsPerPageAllText: {
            type: String,
            default: '$vuetify.dataFooter.itemsPerPageAll'
        },
        showFirstLastPage: Boolean,
        showCurrentPage: Boolean,
        disablePagination: Boolean,
        disableItemsPerPage: Boolean
    },
    computed: {
        disableNextPageIcon: function disableNextPageIcon() {
            return this.options.itemsPerPage < 0 || this.options.page * this.options.itemsPerPage >= this.pagination.itemsLength || this.pagination.pageStop < 0;
        },
        isCustomItemsPerPage: function isCustomItemsPerPage() {
            for (var i = 0; i < this.itemsPerPageOptions.length; i++) {
                if (this.options.itemsPerPage === this.itemsPerPageOptions[i]) return false;
            }
            return true;
        },
        computedItemsPerPageOptions: function computedItemsPerPageOptions() {
            var _this = this;

            var itemsPerPageOptions = this.itemsPerPageOptions.slice();
            if (this.isCustomItemsPerPage) {
                itemsPerPageOptions.push(this.options.itemsPerPage);
                itemsPerPageOptions.sort(function (a, b) {
                    if (a === -1) return 1;else if (b === -1) return -1;else return a - b;
                });
            }
            return itemsPerPageOptions.map(function (value) {
                return {
                    text: value === -1 ? _this.$vuetify.lang.t(_this.itemsPerPageAllText) : String(value), value: value
                };
            });
        }
    },
    methods: {
        updateOptions: function updateOptions(obj) {
            this.$emit('update:options', Object.assign({}, this.options, obj));
        },
        onFirstPage: function onFirstPage() {
            this.updateOptions({ page: 1 });
        },
        onPreviousPage: function onPreviousPage() {
            this.updateOptions({ page: this.options.page - 1 });
        },
        onNextPage: function onNextPage() {
            this.updateOptions({ page: this.options.page + 1 });
        },
        onLastPage: function onLastPage() {
            this.updateOptions({ page: this.pagination.pageCount });
        },
        onChangeItemsPerPage: function onChangeItemsPerPage(itemsPerPage) {
            this.updateOptions({ itemsPerPage: itemsPerPage, page: 1 });
        },
        genItemsPerPageSelect: function genItemsPerPageSelect() {
            return this.$createElement('div', {
                staticClass: 'v-data-footer__select'
            }, [this.$vuetify.lang.t(this.itemsPerPageText), this.$createElement(_VSelect2.default, {
                attrs: {
                    'aria-label': this.itemsPerPageText
                },
                props: {
                    disabled: this.disableItemsPerPage,
                    items: this.computedItemsPerPageOptions,
                    value: this.options.itemsPerPage,
                    hideDetails: true,
                    auto: true,
                    minWidth: '75px'
                },
                on: {
                    input: this.onChangeItemsPerPage
                }
            })]);
        },
        genPaginationInfo: function genPaginationInfo() {
            var children = ['–'];
            if (this.pagination.itemsLength) {
                var itemsLength = this.pagination.itemsLength;
                var pageStart = this.pagination.pageStart + 1;
                var pageStop = itemsLength < this.pagination.pageStop || this.pagination.pageStop < 0 ? itemsLength : this.pagination.pageStop;
                children = this.$scopedSlots['page-text'] ? [this.$scopedSlots['page-text']({ pageStart: pageStart, pageStop: pageStop, itemsLength: itemsLength })] : [pageStart + '-' + pageStop + ' of ' + itemsLength];
            }
            return this.$createElement('div', {
                'class': 'v-data-footer__pagination'
            }, children);
        },
        genIcon: function genIcon(click, disabled, label, icon) {
            return this.$createElement(_VBtn2.default, {
                props: {
                    disabled: disabled || this.disablePagination,
                    icon: true,
                    text: true
                    // dark: this.dark, // TODO: add mixin
                    // light: this.light // TODO: add mixin
                },
                on: {
                    click: click
                },
                attrs: {
                    'aria-label': label // TODO: Localization
                }
            }, [this.$createElement(_VIcon2.default, icon)]);
        },
        genIcons: function genIcons() {
            var before = [];
            var after = [];
            before.push(this.genIcon(this.onPreviousPage, this.options.page === 1, this.$vuetify.lang.t('$vuetify.dataFooter.prevPage'), this.$vuetify.rtl ? this.nextIcon : this.prevIcon));
            after.push(this.genIcon(this.onNextPage, this.disableNextPageIcon, this.$vuetify.lang.t('$vuetify.dataFooter.nextPage'), this.$vuetify.rtl ? this.prevIcon : this.nextIcon));
            if (this.showFirstLastPage) {
                before.unshift(this.genIcon(this.onFirstPage, this.options.page === 1, this.$vuetify.lang.t('$vuetify.dataFooter.firstPage'), this.$vuetify.rtl ? this.lastIcon : this.firstIcon));
                after.push(this.genIcon(this.onLastPage, this.options.page === this.pagination.pageCount || this.options.itemsPerPage === -1, this.$vuetify.lang.t('$vuetify.dataFooter.lastPage'), this.$vuetify.rtl ? this.firstIcon : this.lastIcon));
            }
            return [this.$createElement('div', {
                staticClass: 'v-data-footer__icons-before'
            }, before), this.showCurrentPage && this.$createElement('span', [this.options.page.toString()]), this.$createElement('div', {
                staticClass: 'v-data-footer__icons-after'
            }, after)];
        }
    },
    render: function render() {
        return this.$createElement('div', {
            staticClass: 'v-data-footer'
        }, [this.genItemsPerPageSelect(), this.genPaginationInfo(), this.genIcons()]);
    }
});
// Types
//# sourceMappingURL=VDataFooter.js.map