'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };
// Components

// Mixins

// Utilities


require('../../../src/components/VProgressLinear/VProgressLinear.sass');

var _transitions = require('../transitions');

var _colorable = require('../../mixins/colorable');

var _colorable2 = _interopRequireDefault(_colorable);

var _positionable = require('../../mixins/positionable');

var _proxyable = require('../../mixins/proxyable');

var _proxyable2 = _interopRequireDefault(_proxyable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _helpers = require('../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var baseMixins = (0, _mixins2.default)(_colorable2.default, (0, _positionable.factory)(['absolute', 'fixed', 'top', 'bottom']), _proxyable2.default, _themeable2.default);
/* @vue/component */
exports.default = baseMixins.extend({
    name: 'v-progress-linear',
    props: {
        active: {
            type: Boolean,
            default: true
        },
        backgroundColor: {
            type: String,
            default: null
        },
        backgroundOpacity: {
            type: [Number, String],
            default: null
        },
        bufferValue: {
            type: [Number, String],
            default: 100
        },
        color: {
            type: String,
            default: 'primary'
        },
        height: {
            type: [Number, String],
            default: 4
        },
        indeterminate: Boolean,
        query: Boolean,
        rounded: Boolean,
        stream: Boolean,
        striped: Boolean,
        value: {
            type: [Number, String],
            default: 0
        }
    },
    data: function data() {
        return {
            internalLazyValue: this.value || 0
        };
    },

    computed: {
        __cachedBackground: function __cachedBackground() {
            return this.$createElement('div', this.setBackgroundColor(this.backgroundColor || this.color, {
                staticClass: 'v-progress-linear__background',
                style: this.backgroundStyle
            }));
        },
        __cachedBar: function __cachedBar() {
            return this.$createElement(this.computedTransition, [this.__cachedBarType]);
        },
        __cachedBarType: function __cachedBarType() {
            return this.indeterminate ? this.__cachedIndeterminate : this.__cachedDeterminate;
        },
        __cachedBuffer: function __cachedBuffer() {
            return this.$createElement('div', {
                staticClass: 'v-progress-linear__buffer',
                style: this.styles
            });
        },
        __cachedDeterminate: function __cachedDeterminate() {
            return this.$createElement('div', this.setBackgroundColor(this.color, {
                staticClass: 'v-progress-linear__determinate',
                style: {
                    width: (0, _helpers.convertToUnit)(this.normalizedValue, '%')
                }
            }));
        },
        __cachedIndeterminate: function __cachedIndeterminate() {
            return this.$createElement('div', {
                staticClass: 'v-progress-linear__indeterminate',
                class: {
                    'v-progress-linear__indeterminate--active': this.active
                }
            }, [this.genProgressBar('long'), this.genProgressBar('short')]);
        },
        __cachedStream: function __cachedStream() {
            if (!this.stream) return null;
            return this.$createElement('div', this.setTextColor(this.color, {
                staticClass: 'v-progress-linear__stream',
                style: {
                    width: (0, _helpers.convertToUnit)(100 - this.normalizedBuffer, '%')
                }
            }));
        },
        backgroundStyle: function backgroundStyle() {
            var backgroundOpacity = this.backgroundOpacity == null ? this.backgroundColor ? 1 : 0.3 : parseFloat(this.backgroundOpacity);
            return {
                opacity: backgroundOpacity,
                width: (0, _helpers.convertToUnit)(this.normalizedBuffer, '%')
            };
        },
        classes: function classes() {
            return _extends({
                'v-progress-linear--absolute': this.absolute,
                'v-progress-linear--fixed': this.fixed,
                'v-progress-linear--query': this.query,
                'v-progress-linear--reactive': this.reactive,
                'v-progress-linear--rounded': this.rounded,
                'v-progress-linear--striped': this.striped
            }, this.themeClasses);
        },
        computedTransition: function computedTransition() {
            return this.indeterminate ? _transitions.VFadeTransition : _transitions.VSlideXTransition;
        },
        normalizedBuffer: function normalizedBuffer() {
            return this.normalize(this.bufferValue);
        },
        normalizedValue: function normalizedValue() {
            return this.normalize(this.internalLazyValue);
        },
        reactive: function reactive() {
            return Boolean(this.$listeners.change);
        },
        styles: function styles() {
            var styles = {};
            if (!this.active) {
                styles.height = 0;
            }
            if (!this.indeterminate && parseFloat(this.normalizedBuffer) !== 100) {
                styles.width = (0, _helpers.convertToUnit)(this.normalizedBuffer, '%');
            }
            return styles;
        }
    },
    methods: {
        genContent: function genContent() {
            var slot = (0, _helpers.getSlot)(this, 'default', { value: this.internalLazyValue });
            if (!slot) return null;
            return this.$createElement('div', {
                staticClass: 'v-progress-linear__content'
            }, slot);
        },
        genListeners: function genListeners() {
            var listeners = this.$listeners;
            if (this.reactive) {
                listeners.click = this.onClick;
            }
            return listeners;
        },
        genProgressBar: function genProgressBar(name) {
            return this.$createElement('div', this.setBackgroundColor(this.color, {
                staticClass: 'v-progress-linear__indeterminate',
                class: _defineProperty({}, name, true)
            }));
        },
        onClick: function onClick(e) {
            if (!this.reactive) return;

            var _$el$getBoundingClien = this.$el.getBoundingClientRect(),
                width = _$el$getBoundingClien.width;

            this.internalValue = e.offsetX / width * 100;
        },
        normalize: function normalize(value) {
            if (value < 0) return 0;
            if (value > 100) return 100;
            return parseFloat(value);
        }
    },
    render: function render(h) {
        var data = {
            staticClass: 'v-progress-linear',
            attrs: {
                'role': 'progressbar',
                'aria-valuemin': 0,
                'aria-valuemax': this.normalizedBuffer,
                'aria-valuenow': this.indeterminate ? undefined : this.normalizedValue
            },
            class: this.classes,
            style: {
                bottom: this.bottom ? 0 : undefined,
                height: this.active ? (0, _helpers.convertToUnit)(this.height) : 0,
                top: this.top ? 0 : undefined
            },
            on: this.genListeners()
        };
        return h('div', data, [this.__cachedStream, this.__cachedBackground, this.__cachedBuffer, this.__cachedBar, this.genContent()]);
    }
});
//# sourceMappingURL=VProgressLinear.js.map