'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _themeable = require('../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _mixins = require('./mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_themeable2.default).extend({
    name: 'theme-provider',
    props: {
        root: Boolean
    },
    computed: {
        isDark: function isDark() {
            return this.root ? this.rootIsDark : _themeable2.default.options.computed.isDark.call(this);
        }
    },
    render: function render() {
        return this.$slots.default && this.$slots.default.find(function (node) {
            return !node.isComment && node.text !== ' ';
        });
    }
});
//# sourceMappingURL=ThemeProvider.js.map