import mixins from '../../util/mixins';
import VSelect from '../VSelect/VSelect';
import VChip from '../VChip';
import header from './mixins/header';
export default mixins(header).extend({
    name: 'v-data-table-header-mobile',
    methods: {
        genSortChip: function genSortChip(props) {
            var _this = this;

            var children = [props.item.text];
            var sortIndex = this.options.sortBy.findIndex(function (k) {
                return k === props.item.value;
            });
            var beingSorted = sortIndex >= 0;
            var isDesc = this.options.sortDesc[sortIndex];
            children.push(this.$createElement('div', {
                staticClass: 'v-chip__close',
                class: {
                    'sortable': true,
                    'active': beingSorted,
                    'asc': beingSorted && !isDesc,
                    'desc': beingSorted && isDesc
                }
            }, [this.genSortIcon()]));
            return this.$createElement(VChip, {
                staticClass: 'sortable',
                nativeOn: {
                    click: function click(e) {
                        e.stopPropagation();
                        _this.$emit('sort', props.item.value);
                        // this.dataTable.resetExpanded()
                        // this.dataTable.sort(props.item.value)
                    }
                }
            }, children);
        },
        genSortSelect: function genSortSelect() {
            var _this2 = this;

            return this.$createElement(VSelect, {
                props: {
                    label: 'Sort by',
                    items: this.headers.filter(function (h) {
                        return h.value !== 'dataTableSelect';
                    }),
                    hideDetails: true,
                    multiple: this.options.multiSort,
                    value: this.options.multiSort ? this.options.sortBy : this.options.sortBy[0]
                },
                on: {
                    change: function change(v) {
                        return _this2.$emit('sort', v);
                    }
                },
                scopedSlots: {
                    selection: function selection(props) {
                        return _this2.genSortChip(props);
                    } // TODO: whyyy?
                }
            });
        }
    },
    render: function render(h) {
        var children = [];
        if (this.headers.find(function (header) {
            return header.value === 'dataTableSelect';
        })) {
            children.push(this.genSelectAll());
        }
        children.push(this.genSortSelect());
        var th = h('th', {
            attrs: {
                colspan: this.headers.length
            }
        }, [h('div', { staticClass: 'v-data-table-header-mobile__wrapper' }, children)]);
        var tr = h('tr', [th]);
        return h('thead', {
            staticClass: 'v-data-table-header v-data-table-header-mobile'
        }, [tr]);
    }
});
//# sourceMappingURL=VDataTableHeaderMobile.js.map