var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/styles/components/_selection-controls.sass';
import '../../../src/components/VSwitch/VSwitch.sass';
// Mixins
import Selectable from '../../mixins/selectable';
import VInput from '../VInput';
// Directives
import Touch from '../../directives/touch';
// Components
import { VFabTransition } from '../transitions';
import VProgressCircular from '../VProgressCircular/VProgressCircular';
// Helpers
import { keyCodes } from '../../util/helpers';
/* @vue/component */
export default Selectable.extend({
    name: 'v-switch',
    directives: { Touch: Touch },
    props: {
        inset: Boolean,
        loading: {
            type: [Boolean, String],
            default: false
        },
        flat: {
            type: Boolean,
            default: false
        }
    },
    computed: {
        classes: function classes() {
            return _extends({}, VInput.options.computed.classes.call(this), {
                'v-input--selection-controls v-input--switch': true,
                'v-input--switch--flat': this.flat,
                'v-input--switch--inset': this.inset
            });
        },
        attrs: function attrs() {
            return {
                'aria-checked': String(this.isActive),
                'aria-disabled': String(this.disabled),
                role: 'switch'
            };
        },
        switchData: function switchData() {
            return this.setTextColor(this.loading ? undefined : this.computedColor, {
                class: this.themeClasses
            });
        }
    },
    methods: {
        genDefaultSlot: function genDefaultSlot() {
            return [this.genSwitch(), this.genLabel()];
        },
        genSwitch: function genSwitch() {
            return this.$createElement('div', {
                staticClass: 'v-input--selection-controls__input'
            }, [this.genInput('checkbox', _extends({}, this.$attrs, this.attrs)), this.genRipple(this.setTextColor(this.computedColor, {
                directives: [{
                    name: 'touch',
                    value: {
                        left: this.onSwipeLeft,
                        right: this.onSwipeRight
                    }
                }]
            })), this.$createElement('div', _extends({
                staticClass: 'v-input--switch__track'
            }, this.switchData)), this.$createElement('div', _extends({
                staticClass: 'v-input--switch__thumb'
            }, this.switchData), [this.genProgress()])]);
        },
        genProgress: function genProgress() {
            return this.$createElement(VFabTransition, {}, [this.loading === false ? null : this.$slots.progress || this.$createElement(VProgressCircular, {
                props: {
                    color: this.loading === true || this.loading === '' ? this.color || 'primary' : this.loading,
                    size: 16,
                    width: 2,
                    indeterminate: true
                }
            })]);
        },
        onSwipeLeft: function onSwipeLeft() {
            if (this.isActive) this.onChange();
        },
        onSwipeRight: function onSwipeRight() {
            if (!this.isActive) this.onChange();
        },
        onKeydown: function onKeydown(e) {
            if (e.keyCode === keyCodes.left && this.isActive || e.keyCode === keyCodes.right && !this.isActive) this.onChange();
        }
    }
});
//# sourceMappingURL=VSwitch.js.map