var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

// Mixins
import Delayable from '../delayable';
import Toggleable from '../toggleable';
// Utilities
import mixins from '../../util/mixins';
import { getSlot, getSlotType } from '../../util/helpers';
import { consoleError } from '../../util/console';
var baseMixins = mixins(Delayable, Toggleable);
/* @vue/component */
export default baseMixins.extend({
    name: 'activatable',
    props: {
        activator: {
            default: null,
            validator: function validator(val) {
                return ['string', 'object'].includes(typeof val === 'undefined' ? 'undefined' : _typeof(val));
            }
        },
        disabled: Boolean,
        internalActivator: Boolean,
        openOnHover: Boolean
    },
    data: function data() {
        return {
            activatorElement: null,
            activatorNode: []
        };
    },
    watch: {
        activator: function activator() {
            this.activatorElement = null;
            this.getActivator();
        }
    },
    mounted: function mounted() {
        var slotType = getSlotType(this, 'activator', true);
        if (slotType && ['v-slot', 'normal'].includes(slotType)) {
            consoleError('The activator slot must be bound, try \'<template v-slot:activator="{ on }"><v-btn v-on="on">\'', this);
        }
    },

    methods: {
        genActivator: function genActivator() {
            var node = getSlot(this, 'activator', {
                on: this.genActivatorListeners()
            }) || [];
            this.activatorNode = node;
            return node;
        },
        genActivatorListeners: function genActivatorListeners() {
            var _this = this;

            if (this.disabled) return {};
            var listeners = {};
            if (this.openOnHover) {
                listeners.mouseenter = function (e) {
                    _this.getActivator(e);
                    _this.runDelay('open');
                };
                listeners.mouseleave = function (e) {
                    _this.getActivator(e);
                    _this.runDelay('close');
                };
            } else {
                listeners.click = function (e) {
                    var activator = _this.getActivator(e);
                    if (activator) activator.focus();
                    _this.isActive = !_this.isActive;
                };
            }
            return listeners;
        },
        getActivator: function getActivator(e) {
            // If we've already fetched the activator, re-use
            if (this.activatorElement) return this.activatorElement;
            var activator = null;
            if (this.activator) {
                var target = this.internalActivator ? this.$el : document;
                activator = typeof this.activator === 'string' ? target.querySelector(this.activator) : this.activator;
            } else if (e) {
                activator = e.currentTarget || e.target;
            } else if (this.activatorNode.length) {
                activator = this.activatorNode[0].elm;
            }
            this.activatorElement = activator;
            return this.activatorElement;
        }
    }
});
//# sourceMappingURL=index.js.map