'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Components

// Mixins

// Utilities


require('../../../src/components/VBtn/VBtn.sass');

var _VSheet = require('../VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

var _VProgressCircular = require('../VProgressCircular');

var _VProgressCircular2 = _interopRequireDefault(_VProgressCircular);

var _groupable = require('../../mixins/groupable');

var _toggleable = require('../../mixins/toggleable');

var _positionable = require('../../mixins/positionable');

var _positionable2 = _interopRequireDefault(_positionable);

var _routable = require('../../mixins/routable');

var _routable2 = _interopRequireDefault(_routable);

var _sizeable = require('../../mixins/sizeable');

var _sizeable2 = _interopRequireDefault(_sizeable);

var _console = require('../../util/console');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var baseMixins = (0, _mixins2.default)(_VSheet2.default, _routable2.default, _positionable2.default, _sizeable2.default, (0, _groupable.factory)('btnToggle'), (0, _toggleable.factory)('inputValue')
/* @vue/component */
);
exports.default = baseMixins.extend().extend({
    name: 'v-btn',
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.btnToggle) return '';
                return this.btnToggle.activeClass;
            }
        },
        block: Boolean,
        depressed: Boolean,
        fab: Boolean,
        /* @deprecate */
        flat: Boolean,
        icon: Boolean,
        loading: Boolean,
        outline: Boolean,
        outlined: Boolean,
        round: Boolean,
        rounded: Boolean,
        tag: {
            type: String,
            default: 'button'
        },
        text: Boolean,
        type: {
            type: String,
            default: 'button'
        },
        value: null
    },
    data: function data() {
        return {
            proxyClass: 'v-btn--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-btn': true
            }, _routable2.default.options.computed.classes.call(this), {
                'v-btn--absolute': this.absolute,
                'v-btn--block': this.block,
                'v-btn--bottom': this.bottom,
                'v-btn--contained': this.contained,
                'v-btn--depressed': this.depressed && !this.flat || this.hasOutline,
                'v-btn--disabled': this.disabled,
                'v-btn--fab': this.fab || this.icon,
                'v-btn--fixed': this.fixed,
                'v-btn--flat': this.isFlat,
                'v-btn--icon': this.icon,
                'v-btn--left': this.left,
                'v-btn--loading': this.loading,
                'v-btn--outlined': this.hasOutline,
                'v-btn--right': this.right,
                'v-btn--round': this.isRound,
                'v-btn--rounded': this.round || this.rounded,
                'v-btn--router': this.to,
                'v-btn--text': this.text,
                'v-btn--top': this.top
            }, this.themeClasses, this.groupClasses, this.elevationClasses, this.sizeableClasses);
        },
        contained: function contained() {
            return Boolean(!this.isFlat && !this.depressed &&
            // Contained class only adds elevation
            // is not needed if user provides value
            !this.elevation);
        },
        computedRipple: function computedRipple() {
            var defaultRipple = this.icon || this.fab ? { circle: true } : true;
            if (this.disabled) return false;else return this.ripple != null ? this.ripple : defaultRipple;
        },

        // TODO: remove deprecated
        hasOutline: function hasOutline() {
            return this.outline || this.outlined;
        },
        isFlat: function isFlat() {
            return Boolean(this.icon || this.text || this.flat || this.hasOutline);
        },
        isRound: function isRound() {
            return Boolean(this.icon || this.fab);
        },
        styles: function styles() {
            return _extends({}, this.measurableStyles);
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.flat) (0, _console.deprecate)('flat', 'text', this);
        /* istanbul ignore next */
        if (this.round) (0, _console.deprecate)('round', 'rounded', this);
        /* istanbul ignore next */
        if (this.outline) (0, _console.deprecate)('outline', 'outlined', this);
    },

    methods: {
        // Prevent focus to match md spec
        click: function click(e) {
            !this.fab && e.detail && this.$el.blur();
            this.$emit('click', e);
            this.btnToggle && this.toggle();
        },
        genContent: function genContent() {
            return this.$createElement('span', {
                staticClass: 'v-btn__content'
            }, this.$slots.default);
        },
        genLoader: function genLoader() {
            return this.$createElement('span', {
                class: 'v-btn__loader'
            }, this.$slots.loader || [this.$createElement(_VProgressCircular2.default, {
                props: {
                    indeterminate: true,
                    size: 23,
                    width: 2
                }
            })]);
        }
    },
    render: function render(h) {
        var children = [this.genContent(), this.loading && this.genLoader()];
        var setColor = !this.isFlat ? this.setBackgroundColor : this.setTextColor;

        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        if (tag === 'button') data.attrs.type = this.type;
        data.attrs.value = ['string', 'number'].includes(_typeof(this.value)) ? this.value : JSON.stringify(this.value);
        return h(tag, setColor(this.color, data), children);
    }
});
//# sourceMappingURL=VBtn.js.map