'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

require('../../../src/components/VDataTable/VSimpleTable.sass');

var _helpers = require('../../util/helpers');

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = (0, _mixins2.default)(_themeable2.default).extend({
    name: 'v-simple-table',
    props: {
        fixedHeader: Boolean,
        height: [Number, String],
        dense: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-data-table--dense': this.dense,
                'v-data-table--fixed-height': !!this.height && !this.fixedHeader,
                'v-data-table--fixed-header': this.fixedHeader
            }, this.themeClasses);
        }
    },
    methods: {
        genWrapper: function genWrapper() {
            return this.$slots.wrapper || this.$createElement('div', {
                staticClass: 'v-data-table__wrapper',
                style: {
                    height: (0, _helpers.convertToUnit)(this.height)
                }
            }, [this.$createElement('table', this.$slots.default)]);
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-data-table',
            class: this.classes
        }, [this.$slots.top, this.genWrapper(), this.$slots.bottom]);
    }
});
//# sourceMappingURL=VSimpleTable.js.map