'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.VListTileSubTitle = exports.VListTileTitle = exports.VListTileContent = exports.VListTileActionText = exports.VListTileIcon = exports.VListTileAvatar = exports.VListTileAction = exports.VListTile = exports.VListItemGroup = exports.VListItemIcon = exports.VListItemAvatar = exports.VListItemAction = exports.VListItem = exports.VListGroup = exports.VList = exports.VListItemSubtitle = exports.VListItemTitle = exports.VListItemContent = exports.VListItemActionText = undefined;

var _helpers = require('../../util/helpers');

var _console = require('../../util/console');

var _VList = require('./VList');

var _VList2 = _interopRequireDefault(_VList);

var _VListGroup = require('./VListGroup');

var _VListGroup2 = _interopRequireDefault(_VListGroup);

var _VListItem = require('./VListItem');

var _VListItem2 = _interopRequireDefault(_VListItem);

var _VListItemGroup = require('./VListItemGroup');

var _VListItemGroup2 = _interopRequireDefault(_VListItemGroup);

var _VListItemAction = require('./VListItemAction');

var _VListItemAction2 = _interopRequireDefault(_VListItemAction);

var _VListItemAvatar = require('./VListItemAvatar');

var _VListItemAvatar2 = _interopRequireDefault(_VListItemAvatar);

var _VListItemIcon = require('./VListItemIcon');

var _VListItemIcon2 = _interopRequireDefault(_VListItemIcon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var VListItemActionText = exports.VListItemActionText = (0, _helpers.createSimpleFunctional)('v-list-item__action-text', 'span');
var VListItemContent = exports.VListItemContent = (0, _helpers.createSimpleFunctional)('v-list-item__content', 'div');
var VListItemTitle = exports.VListItemTitle = (0, _helpers.createSimpleFunctional)('v-list-item__title', 'div');
var VListItemSubtitle = exports.VListItemSubtitle = (0, _helpers.createSimpleFunctional)('v-list-item__subtitle', 'div');
var VListTile = _VListItem2.default.extend({
    mounted: function mounted() {
        (0, _console.deprecate)('v-list-tile', 'v-list-item');
    }
});
var VListTileAction = _VListItemAction2.default.extend({
    mounted: function mounted() {
        (0, _console.deprecate)('v-list-tile-action', 'v-list-item-action');
    }
});
var VListTileAvatar = _VListItemAvatar2.default.extend({
    mounted: function mounted() {
        (0, _console.deprecate)('v-list-tile-avatar', 'v-list-item-avatar');
    }
});
var VListTileIcon = _VListItemIcon2.default.extend({
    mounted: function mounted() {
        (0, _console.deprecate)('v-list-tile-icon', 'v-list-item-icon');
    }
});
var VListTileActionText = VListItemActionText.extend({
    render: function render(h, context) {
        var render = VListItemActionText.options.render.call(this, h, context);
        (0, _console.deprecate)('v-list-tile-action-text', 'v-list-item-action-text');
        return render;
    }
});
var VListTileContent = VListItemContent.extend({
    render: function render(h, context) {
        var render = VListItemContent.options.render.call(this, h, context);
        (0, _console.deprecate)('v-list-tile-content', 'v-list-item-content');
        return render;
    }
});
var VListTileTitle = VListItemTitle.extend({
    render: function render(h, context) {
        var render = VListItemTitle.options.render.call(this, h, context);
        (0, _console.deprecate)('v-list-tile-title', 'v-list-item-title');
        return render;
    }
});
var VListTileSubTitle = VListItemSubtitle.extend({
    render: function render(h, context) {
        var render = VListItemSubtitle.options.render.call(this, h, context);
        (0, _console.deprecate)('v-list-tile-subtitle', 'v-list-item-subtitle');
        return render;
    }
});
exports.VList = _VList2.default;
exports.VListGroup = _VListGroup2.default;
exports.VListItem = _VListItem2.default;
exports.VListItemAction = _VListItemAction2.default;
exports.VListItemAvatar = _VListItemAvatar2.default;
exports.VListItemIcon = _VListItemIcon2.default;
exports.VListItemGroup = _VListItemGroup2.default;
exports.VListTile = VListTile;
exports.VListTileAction = VListTileAction;
exports.VListTileAvatar = VListTileAvatar;
exports.VListTileIcon = VListTileIcon;
exports.VListTileActionText = VListTileActionText;
exports.VListTileContent = VListTileContent;
exports.VListTileTitle = VListTileTitle;
exports.VListTileSubTitle = VListTileSubTitle;
exports.default = {
    $_vuetify_subcomponents: {
        VList: _VList2.default,
        VListGroup: _VListGroup2.default,
        VListItem: _VListItem2.default,
        VListItemAction: _VListItemAction2.default,
        VListItemActionText: VListItemActionText,
        VListItemAvatar: _VListItemAvatar2.default,
        VListItemContent: VListItemContent,
        VListItemGroup: _VListItemGroup2.default,
        VListItemSubtitle: VListItemSubtitle,
        VListItemTitle: VListItemTitle,
        // Deprecated
        VListTile: VListTile,
        VListTileAction: VListTileAction,
        VListTileAvatar: VListTileAvatar,
        VListTileIcon: VListTileIcon,
        VListTileActionText: VListTileActionText,
        VListTileContent: VListTileContent,
        VListTileTitle: VListTileTitle,
        VListTileSubTitle: VListTileSubTitle
    }
};
//# sourceMappingURL=index.js.map