'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Mixins

// Types


require('../../../src/styles/components/_selection-controls.sass');

require('../../../src/components/VRadioGroup/VRadioGroup.sass');

var _VInput = require('../VInput');

var _VInput2 = _interopRequireDefault(_VInput);

var _VItemGroup = require('../VItemGroup/VItemGroup');

var _comparable = require('../../mixins/comparable');

var _comparable2 = _interopRequireDefault(_comparable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var baseMixins = (0, _mixins2.default)(_comparable2.default, _VItemGroup.BaseItemGroup, _VInput2.default);
/* @vue/component */
exports.default = baseMixins.extend({
    name: 'v-radio-group',
    provide: function provide() {
        return {
            radioGroup: this
        };
    },

    props: {
        column: {
            type: Boolean,
            default: true
        },
        height: {
            type: [Number, String],
            default: 'auto'
        },
        name: String,
        row: Boolean,
        // If no value set on VRadio
        // will match valueComparator
        // force default to null
        value: {
            default: null
        }
    },
    computed: {
        classes: function classes() {
            return _extends({}, _VInput2.default.options.computed.classes.call(this), {
                'v-input--selection-controls v-input--radio-group': true,
                'v-input--radio-group--column': this.column && !this.row,
                'v-input--radio-group--row': this.row
            });
        }
    },
    methods: {
        genDefaultSlot: function genDefaultSlot() {
            return this.$createElement('div', {
                staticClass: 'v-input--radio-group__input',
                attrs: {
                    role: 'radiogroup'
                }
            }, _VInput2.default.options.methods.genDefaultSlot.call(this));
        },
        genInputSlot: function genInputSlot() {
            var render = _VInput2.default.options.methods.genInputSlot.call(this);
            delete render.data.on.click;
            return render;
        },

        onClick: _VItemGroup.BaseItemGroup.options.methods.onClick
    }
});
//# sourceMappingURL=VRadioGroup.js.map