'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Mixins

// Utilities


require('../../../src/components/VStepper/VStepper.sass');

var _registrable = require('../../mixins/registrable');

var _proxyable = require('../../mixins/proxyable');

var _proxyable2 = _interopRequireDefault(_proxyable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

var _console = require('../../util/console');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var baseMixins = (0, _mixins2.default)((0, _registrable.provide)('stepper'), _proxyable2.default, _themeable2.default);
/* @vue/component */
exports.default = baseMixins.extend({
    name: 'v-stepper',
    provide: function provide() {
        return {
            stepClick: this.stepClick,
            isVertical: this.vertical
        };
    },

    props: {
        nonLinear: Boolean,
        altLabels: Boolean,
        vertical: Boolean
    },
    data: function data() {
        return {
            isBooted: false,
            steps: [],
            content: [],
            isReverse: false
        };
    },

    computed: {
        classes: function classes() {
            return _extends({
                'v-stepper--is-booted': this.isBooted,
                'v-stepper--vertical': this.vertical,
                'v-stepper--alt-labels': this.altLabels,
                'v-stepper--non-linear': this.nonLinear
            }, this.themeClasses);
        }
    },
    watch: {
        internalValue: function internalValue(val, oldVal) {
            this.isReverse = Number(val) < Number(oldVal);
            oldVal && (this.isBooted = true);
            /* istanbul ignore if */
            if (this.$listeners.input) {
                this.$emit('input', val);
            }
            this.updateView();
        }
    },
    created: function created() {
        /* istanbul ignore if */
        if (this.$listeners.input) {
            (0, _console.deprecate)('input', 'change', this);
        }
    },
    mounted: function mounted() {
        this.internalLazyValue = this.value || (this.steps[0] || {}).step || 1;
        this.updateView();
    },

    methods: {
        register: function register(item) {
            if (item.$options.name === 'v-stepper-step') {
                this.steps.push(item);
            } else if (item.$options.name === 'v-stepper-content') {
                item.isVertical = this.vertical;
                this.content.push(item);
            }
        },
        unregister: function unregister(item) {
            if (item.$options.name === 'v-stepper-step') {
                this.steps = this.steps.filter(function (i) {
                    return i !== item;
                });
            } else if (item.$options.name === 'v-stepper-content') {
                item.isVertical = this.vertical;
                this.content = this.content.filter(function (i) {
                    return i !== item;
                });
            }
        },
        stepClick: function stepClick(step) {
            var _this = this;

            this.$nextTick(function () {
                return _this.internalValue = step;
            });
        },
        updateView: function updateView() {
            for (var index = this.steps.length; --index >= 0;) {
                this.steps[index].toggle(this.internalValue);
            }
            for (var _index = this.content.length; --_index >= 0;) {
                this.content[_index].toggle(this.internalValue, this.isReverse);
            }
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-stepper',
            class: this.classes
        }, this.$slots.default);
    }
});
//# sourceMappingURL=VStepper.js.map